<?php

use \vendor\isenselabs\autodetect\config as Config;

class ControllerExtensionModuleAutoDetect extends Controller {

	private $moduleModel;

    public function __construct($registry) {
        parent::__construct($registry);

        $this->load->model(Config::autodetect_path);
        $this->moduleModel = $this->{Config::autodetect_model_call};

        $this->load->model('setting/store');
        $this->load->model('setting/setting');
        $this->load->model('localisation/language');
        $this->load->model('localisation/currency');
        $this->load->model('localisation/country');
        $this->load->model('design/layout');
    }

    public function index() {
        $this->load->language(Config::autodetect_path);
        // Variables
        $data['moduleName']   = Config::autodetect_name;
        $data['moduleNameSmall'] = Config::autodetect_name_small;
        $data['modulePath']   = Config::autodetect_path;

        $extensionsLink = $this->url->link(Config::autodetect_extensions_link, 'user_token=' . $this->session->data['user_token'] . Config::autodetect_extensions_link_params, 'SSL');

        $catalogURL = $this->getCatalogURL();

        $this->document->addStyle('view/stylesheet/'.Config::autodetect_name_small.'/'.Config::autodetect_name_small.'.css');

        $this->document->setTitle($this->language->get('heading_title'));

        if(!isset($this->request->get['store_id'])) {
           $this->request->get['store_id'] = 0;
        }

        $store = $this->getCurrentStore($this->request->get['store_id']);

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            if (!$this->user->hasPermission('modify', Config::autodetect_path)) {
                $this->response->redirect($this->url->link(Config::autodetect_path, 'store_id='.$this->request->post['store_id'] . '&user_token=' . $this->session->data['user_token'], 'SSL'));
            }

            if (!empty($_POST['OaXRyb1BhY2sgLSBDb21'])) {
                $this->request->post[Config::autodetect_name]['LicensedOn'] = $_POST['OaXRyb1BhY2sgLSBDb21'];
            }

            if (!empty($_POST['cHRpbWl6YXRpb24ef4fe'])) {
                $this->request->post[Config::autodetect_name]['License'] = json_decode(base64_decode($_POST['cHRpbWl6YXRpb24ef4fe']), true);
            }

			if(!isset($this->request->post[$this->moduleData_module])) {
				$this->request->post[$this->moduleData_module] = array();
			}

            if(!empty($this->request->post[Config::autodetect_name]['RedirectTo'])) {
               foreach($this->request->post[Config::autodetect_name]['RedirectTo'] as $redirect_rule) {
                    if(!empty($redirect_rule["link"])) {
                        $redirect_rule["link"] = urldecode($redirect_rule["link"]);
                    }
               }
            }

            if (!empty($this->request->post[Config::autodetect_name]['Enabled'])) {
                $this->model_setting_setting->editSetting('module_autodetect', ['module_autodetect_status' => ($this->request->post[Config::autodetect_name]['Enabled'] == 'yes')], $this->request->post['store_id']);
            }

            $this->model_setting_setting->editSetting(Config::autodetect_name, $this->request->post, $this->request->post['store_id']);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link(Config::autodetect_path, 'store_id='.$this->request->post['store_id'] . '&user_token=' . $this->session->data['user_token'], 'SSL'));
        }

				if (isset($this->session->data['success'])) {
					$data['success'] = $this->session->data['success'];
					unset($this->session->data['success']);
				} else {
					$data['success'] = '';
				}

				if (isset($this->error['warning'])) {
					$data['error_warning'] = $this->error['warning'];
				} else {
					$data['error_warning'] = '';
				}

        if (isset($this->error['code'])) {
            $data['error_code'] = $this->error['code'];
        } else {
            $data['error_code'] = '';
        }

        $data['breadcrumbs']   = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $extensionsLink,
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link(Config::autodetect_path, 'user_token=' . $this->session->data['user_token'], 'SSL'),
        );

        $languageVariables = array(
		    // Main
						'heading_title',
						'error_permission',
						'text_success',
						'text_enabled',
						'text_disabled',
						'button_cancel',
						'save_changes',
						'text_default',
						'text_module',
            'text_controlpanel',
            'text_language',
            'text_currency',
            'text_customredirect',
            'text_support',
            'text_choose_countries',
            'text_module_status',
            'text_module_status_help',
            'text_detect_method',
            'text_synchronous',
            'text_asynchronous',
            'text_synchronous_desc',
            'text_asynchronous_desc',
            'text_add_country',
            'text_redirectto',
            'text_coming_from',
            'text_use_manual_redirect',
            'text_stripe_text',
            'text_button_text',
            'text_puturl_placeholder',
            'text_putustripe_text_placeholder',
            'text_putustripe_button_placeholder',
            'text_create_redirect',
            'text_select_all',
            'text_deselect_all'
        );

        foreach ($languageVariables as $languageVariable) {
            $data[$languageVariable] = $this->language->get($languageVariable);
        }

        $data['heading_title'] .= " " . Config::autodetect_version;

				$data['currency']				= $this->config->get('config_currency');
        $data['stores']				  	= array_merge(array(0 => array('store_id' => '0', 'name' => $this->config->get('config_name') . ' (' . $data['text_default'].')', 'url' => HTTP_SERVER, 'ssl' => HTTPS_SERVER)), $this->model_setting_store->getStores());
        $data['error_warning']          = '';
        $data['languages']              = $this->model_localisation_language->getLanguages();

        foreach ($data['languages'] as $key => $value) {
            $data['languages'][$key]['flag_url'] = 'language/'.$data['languages'][$key]['code'].'/'.$data['languages'][$key]['code'].'.png"';
        }

        $data['currencies']             = $this->model_localisation_currency->getCurrencies();
				$data['countries']              = $this->model_localisation_country->getCountries();
        $data['store']                  = $store;
        $data['token']                  = $this->session->data['user_token'];
        $data['action']                 = $this->url->link(Config::autodetect_path, 'user_token=' . $this->session->data['user_token'], 'SSL');
        $data['cancel']                 = $extensionsLink;
        $data['data']                   = $this->model_setting_setting->getSetting(Config::autodetect_name, $store['store_id']);
        $data['layouts']                = $this->model_design_layout->getLayouts();
        $data['catalog_url']			= $catalogURL;

				if (isset($data['data'][Config::autodetect_name])) {
					$data['moduleData'] = $data['data'][Config::autodetect_name];
				} else {
					$data['moduleData'] = array();
				}

				$data['header'] = $this->load->controller('common/header');
				$data['column_left'] = $this->load->controller('common/column_left');
				$data['footer'] = $this->load->controller('common/footer');


        if (empty($data['moduleData']['LicensedOn'])) {
            $hostname = (!empty($_SERVER['HTTP_HOST'])) ? $_SERVER['HTTP_HOST'] : '' ;
            $data['hostname'] = (strstr($hostname,'http://') === false) ? 'http://'.$hostname: $hostname;
            $data['domHostname'] = base64_encode($data['hostname']);
            $data['timenow'] = time();
            $data['b64'] = base64_decode('ICAgIDxkaXYgY2xhc3M9ImFsZXJ0IGFsZXJ0LWRhbmdlciBmYWRlIGluIj4NCiAgICAgICAgPGJ1dHRvbiB0eXBlPSJidXR0b24iIGNsYXNzPSJjbG9zZSIgZGF0YS1kaXNtaXNzPSJhbGVydCIgYXJpYS1oaWRkZW49InRydWUiPsOXPC9idXR0b24+DQogICAgICAgIDxoND5XYXJuaW5nISBVbmxpY2Vuc2VkIHZlcnNpb24gb2YgdGhlIG1vZHVsZSE8L2g0Pg0KICAgICAgICA8cD5Zb3UgYXJlIHJ1bm5pbmcgYW4gdW5saWNlbnNlZCB2ZXJzaW9uIG9mIHRoaXMgbW9kdWxlISBZb3UgbmVlZCB0byBlbnRlciB5b3VyIGxpY2Vuc2UgY29kZSB0byBlbnN1cmUgcHJvcGVyIGZ1bmN0aW9uaW5nLCBhY2Nlc3MgdG8gc3VwcG9ydCBhbmQgdXBkYXRlcy48L3A+PGRpdiBzdHlsZT0iaGVpZ2h0OjVweDsiPjwvZGl2Pg0KICAgICAgICA8YSBjbGFzcz0iYnRuIGJ0bi1kYW5nZXIiIGhyZWY9ImphdmFzY3JpcHQ6dm9pZCgwKSIgb25jbGljaz0iJCgnYVtocmVmPSNpc2Vuc2Vfc3VwcG9ydF0nKS50cmlnZ2VyKCdjbGljaycpIj5FbnRlciB5b3VyIGxpY2Vuc2UgY29kZTwvYT4NCiAgICA8L2Rpdj4=');
        } else {
            $data['cHRpbWl6YXRpb24ef4fe'] = base64_encode(json_encode($data['moduleData']['License']));
            $data['expires'] = date("F j, Y",strtotime($data['moduleData']['License']['licenseExpireDate']));
        }

        $data['supportURL'] = 'http://isenselabs.com/tickets/open/' . base64_encode('Support Request').'/'.base64_encode('143').'/'. base64_encode($_SERVER['SERVER_NAME']);

        $countries_iso = array();
        foreach ($data['countries'] as $c) {
            $countries_iso[$c['iso_code_2']] = $c['name'];
        }
        $data['countries_iso'] = $countries_iso;

        if (!isset($data['data']['AutoDetect']['Redirect'])) {
            $data['data']['AutoDetect']['Redirect'] = array();
        }

        $data['tab_controlpanel']   = $this->load->view($data['modulePath'] . '/tab_controlpanel', $data);
        $data['tab_language']       = $this->load->view($data['modulePath'] . '/tab_language', $data);
        $data['tab_currency']       = $this->load->view($data['modulePath'] . '/tab_currency', $data);
        $data['tab_customredirect'] = $this->load->view($data['modulePath'] . '/tab_customredirect', $data);
        $data['tab_support']        = $this->load->view($data['modulePath'] . '/tab_support', $data);

		$this->response->setOutput($this->load->view(Config::autodetect_path, $data));
    }

    public function install() {
        $this->load->model('setting/event');

        $events = array(
            'catalog/view/common/header/before' => 'extension/module/autodetect/viewCommonHeaderBefore',
            'catalog/view/common/header/after' => 'extension/module/autodetect/viewCommonHeaderAfter',
            'catalog/controller/*/before' => 'extension/module/autodetect/controllerAllBefore'
        );

        foreach ($events as $trigger => $handler) {
            $this->model_setting_event->addEvent(Config::autodetect_event_group, $trigger, $handler, 1, 0);
        }

        $this->load->language(Config::autodetect_path);
        $data['modulePath']   = Config::autodetect_path;

			if($this->table_exists('ip2nation')) {

	      $this->db->query("TRUNCATE TABLE ".DB_PREFIX."ip2nation");
	        }

    }

    public function uninstall() {
        $this->load->model('setting/event');
        $this->model_setting_event->deleteEventByCode(Config::autodetect_event_group);
    }

    private function table_exists($table) {
		$dbtable = $this->db->query("SHOW TABLES LIKE \"%".$table."%\"");
        return !empty($dbtable->row);
    }

    private function getCatalogURL() {
        if (isset($_SERVER['HTTPS']) && (($_SERVER['HTTPS'] == 'on') || ($_SERVER['HTTPS'] == '1'))) {
            $storeURL = HTTPS_CATALOG;
        } else {
            $storeURL = HTTP_CATALOG;
        }
        return $storeURL;
    }

    private function getServerURL() {
        if (isset($_SERVER['HTTPS']) && (($_SERVER['HTTPS'] == 'on') || ($_SERVER['HTTPS'] == '1'))) {
            $storeURL = HTTPS_SERVER;
        } else {
            $storeURL = HTTP_SERVER;
        }
        return $storeURL;
    }

    private function getCurrentStore($store_id) {
        if($store_id && $store_id != 0) {
            $store = $this->model_setting_store->getStore($store_id);
        } else {
            $store['store_id'] = 0;
            $store['name'] = $this->config->get('config_name');
            $store['url'] = $this->getCatalogURL();
        }
        return $store;
    }
}

?>
