<?php
class ControllerExtensionModuleEasyProductstoCategories extends Controller { 
	private $error = array();

	public function index() {
		$this->load->language('extension/module/easy_products_to_categories');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['store'] = array();
		$this->load->model('setting/store');
		$stores = $this->model_setting_store->getStores(null);
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'], 
				'name'        => strip_tags(html_entity_decode($store['name'], ENT_QUOTES, 'UTF-8'))
			);
		}

		$data['manufacturers'] = array();
		$this->load->model('catalog/manufacturer');
		$manufacturers = $this->model_catalog_manufacturer->getManufacturers(null);
		foreach ($manufacturers as $manufacturer) {
			$data['manufacturers'][] = array(
				'manufacturer_id' => $manufacturer['manufacturer_id'], 
				'name'        => strip_tags(html_entity_decode($manufacturer['name'], ENT_QUOTES, 'UTF-8'))
			);
		}

		$data['easy_categories'] = array();
		$this->load->model('catalog/category');
		$categories = $this->model_catalog_category->getCategories(array('sort'=>'name', 'order'=>'ASC'));
		foreach ($categories as $category) {
			$data['easy_categories'][] = array(
				'category_id' => $category['category_id'], 
				'name'        => strip_tags(html_entity_decode($category['name'], ENT_QUOTES, 'UTF-8'))
			);
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/easy_products_to_categories', 'user_token=' . $this->session->data['user_token'], true)
		);

   		$data['user_token'] = $this->session->data['user_token'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/easy_products_to_categories', $data));
	}

	public function install() {
		$this->load->model('setting/event');

		$this->model_setting_event->addEvent('easy_product_to_categories_admin_menu', 'admin/view/common/column_left/before', 'extension/module/easy_products_to_categories/adminMenu');
	}

	public function uninstall() {
		$this->load->model('setting/event');

		$this->model_setting_event->deleteEventByCode('easy_product_to_categories_admin_menu');
	}

	public function adminMenu($route, &$data) {
        $this->load->language('extension/module/easy_products_to_categories');

        if ($this->user->hasPermission('access', 'extension/module/easy_products_to_categories')) {
            $easy_menu[] = array(
                'name'     => $this->language->get('heading_title'),
                'href'     => $this->url->link('extension/module/easy_products_to_categories', 'user_token=' . $this->session->data['user_token'], true),
                'children' => array()
            );

        	foreach ($data['menus'] as $key=>$menu) {
        		if ($menu['id'] == 'menu-catalog') {
        			$data['menus'][$key]['children'] = array_merge($data['menus'][$key]['children'], $easy_menu);
        		}
        	}
        }
    }

	public function getProducts() {
		$category = $this->request->get['category'];
		$name = $this->request->get['name'];
		$store = $this->request->get['store'];
		$manufacturer = $this->request->get['manufacturer'];
		$status = $this->request->get['status'];

		$this->load->model('extension/module/easy_products_to_categories');

		$data['easy_products'] = array();
		$products = $this->model_extension_module_easy_products_to_categories->getEasyProducts($category, $name, $store, $manufacturer, $status);
		foreach ($products as $product) {
			$data['easy_products'][] = array(
				'product_id' => $product['product_id'],
				'name'        => strip_tags(html_entity_decode($product['name'], ENT_QUOTES, 'UTF-8'))
			);
		}

		if (isset($data['easy_products'])){
			$this->response->setOutput(json_encode($data['easy_products']));	
		}else{
			$this->response->setOutput(json_encode(null));
		}
	}

	public function categoryProducts() {
		$category_id = $this->request->get['category_id'];

		$this->load->model('extension/module/easy_products_to_categories');

		$data['easy_categoryproducts'] = array();
		$products = $this->model_extension_module_easy_products_to_categories->getEasyCategoryProducts((int)$category_id);
		foreach ($products as $product) {
			$data['easy_categoryproducts'][] = array(
				'product_id' => $product['product_id']
			);
		}

		if (isset($data['easy_categoryproducts'])){
			$this->response->setOutput(json_encode($data['easy_categoryproducts']));	
		}else{
			$this->response->setOutput(json_encode(null));
		}
	}

	public function InsertAssignment() {
		$category_id = $this->request->get['category_id'];
		$product_id = $this->request->get['product_id'];

		$this->load->model('extension/module/easy_products_to_categories');
		$result = $this->model_extension_module_easy_products_to_categories->InsertAssignment((int)$category_id, (int)$product_id);

		$this->response->setOutput(json_encode('success'));
	}

	public function DeleteAssignment() {
		$category_id = $this->request->get['category_id'];
		$product_id = $this->request->get['product_id'];

		$this->load->model('extension/module/easy_products_to_categories');
		$result = $this->model_extension_module_easy_products_to_categories->DeleteAssignment((int)$category_id, (int)$product_id);

		$this->response->setOutput(json_encode('success'));
	}
}
?>
