<?php
class ControllerExtensionModuleGenerator extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/generator');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_generator', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		if (isset($this->error['module_generator_order_min'])) {
			$data['error_generator_order_min'] = $this->error['module_generator_order_min'];
		} else {
			$data['error_generator_order_min'] = '';
		}

		if (isset($this->error['module_generator_order_max'])) {
			$data['error_generator_order_max'] = $this->error['module_generator_order_max'];
		} else {
			$data['error_generator_order_max'] = '';
		}

		if (isset($this->error['module_generator_invoice_min'])) {
			$data['error_generator_invoice_min'] = $this->error['module_generator_invoice_min'];
		} else {
			$data['error_generator_invoice_min'] = '';
		}

		if (isset($this->error['module_generator_invoice_max'])) {
			$data['error_generator_invoice_max'] = $this->error['module_generator_invoice_max'];
		} else {
			$data['error_generator_invoice_max'] = '';
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/generator', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/generator', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$this->load->model('extension/module/generator');

		$data['last_order_id'] = $this->model_extension_module_generator->getLastOrderID();
		$data['next_order_id'] = $this->model_extension_module_generator->getNextOrderID();
		$data['invoice_prefixs'] = $this->model_extension_module_generator->getInvoicePrefix();

		$data['select_invoice_prefix'] = $this->config->get('config_invoice_prefix');

		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->request->post['id_push'])) {
			$data['id_push'] = $this->request->post['id_push'];
        } else {
			$data['id_push'] = '';
        }

		if (isset($this->request->post['module_generator_order_min'])) {
			$data['module_generator_order_min'] = $this->request->post['module_generator_order_min'];
		} elseif ($this->config->get('module_generator_order_min')) {
			$data['module_generator_order_min'] = $this->config->get('module_generator_order_min');
        } else {
			$data['module_generator_order_min'] = '1';
        }

		if (isset($this->request->post['module_generator_order_max'])) {
			$data['module_generator_order_max'] = $this->request->post['module_generator_order_max'];
		} elseif ($this->config->get('module_generator_order_max')) {
			$data['module_generator_order_max'] = $this->config->get('module_generator_order_max');
        } else {
			$data['module_generator_order_max'] = '1';
        }

		if (isset($this->request->post['module_generator_status'])) {
			$data['module_generator_status'] = $this->request->post['module_generator_status'];
		} else {
			$data['module_generator_status'] = $this->config->get('module_generator_status');
		}

		if (isset($this->request->post['module_generator_invoice_type'])) {
			$data['module_generator_invoice_type'] = $this->request->post['module_generator_invoice_type'];
		} else {
			$data['module_generator_invoice_type'] = $this->config->get('module_generator_invoice_type');
		}

		if (isset($this->request->post['module_generator_invoice_min'])) {
			$data['module_generator_invoice_min'] = $this->request->post['module_generator_invoice_min'];
		} elseif ($this->config->get('module_generator_invoice_min')) {
			$data['module_generator_invoice_min'] = $this->config->get('module_generator_invoice_min');
        } else {
			$data['module_generator_invoice_min'] = '1';
        }

		if (isset($this->request->post['module_generator_invoice_max'])) {
			$data['module_generator_invoice_max'] = $this->request->post['module_generator_invoice_max'];
		} elseif ($this->config->get('module_generator_invoice_max')) {
			$data['module_generator_invoice_max'] = $this->config->get('module_generator_invoice_max');
        } else {
			$data['module_generator_invoice_max'] = '1';
        }

		if (isset($this->request->post['module_generator_invoice_status'])) {
			$data['module_generator_invoice_status'] = $this->request->post['module_generator_invoice_status'];
		} else {
			$data['module_generator_invoice_status'] = $this->config->get('module_generator_invoice_status');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/generator', $data));
	}

	public function getLastInvoiceNo() {
		$json = array();

        $this->load->model('extension/module/generator');

		$last_invoice_no = $this->model_extension_module_generator->getLastInvoiceNo($this->request->get['invoice_prefix']);

        if ($last_invoice_no) {
           $json['last_invoice_no'] = $last_invoice_no;
        }

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function push() {
		$json = array();

		$this->load->language('extension/module/generator');
        $this->load->model('extension/module/generator');

		$last_order_id = $this->model_extension_module_generator->getLastOrderID();

		if (!$this->user->hasPermission('modify', 'extension/module/generator')) {
			$json['error'] = $this->language->get('error_permission');
        } else {
          if ((!preg_match('/^[0-9]*$/', $this->request->get['order_id'])) || ($this->request->get['order_id'] < 1) || ($this->request->get['order_id'] > 99999999)) {
             $json['error'] = $this->language->get('error_valid');
          } else {
            if ($this->request->get['order_id'] > $last_order_id) {
               $push_order_id = $this->model_extension_module_generator->setNextOrderID($this->request->get['order_id']);

               if ($push_order_id) {
                  $json['next_order_id'] = $push_order_id;
                  $json['success'] = $this->language->get('text_success_id');
               } else {
                 $json['error'] = $this->language->get('error_action');
               }
            } else {
              $json['error'] = $this->language->get('error_order_id');
            }
          }
        }
        
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function refresh() {
		$json = array();

        $this->load->model('extension/module/generator');

		$json['last_order_id'] = $this->model_extension_module_generator->getLastOrderID();
		$json['next_order_id'] = $this->model_extension_module_generator->getNextOrderID();
		$json['last_invoice_no'] = $this->model_extension_module_generator->getLastInvoiceNo($this->request->get['invoice_prefix']);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/generator')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

        if ((!preg_match('/^[0-9]*$/', $this->request->post['module_generator_order_min'])) || ($this->request->post['module_generator_order_min'] < 1) || ($this->request->post['module_generator_order_min'] > 999)) {
            $this->error['module_generator_order_min'] = $this->language->get('error_number');
        }

        if ((!preg_match('/^[0-9]*$/', $this->request->post['module_generator_order_max'])) || ($this->request->post['module_generator_order_max'] < 1) || ($this->request->post['module_generator_order_max'] > 999)) {
            $this->error['module_generator_order_max'] = $this->language->get('error_number');
        }

        if ((!preg_match('/^[0-9]*$/', $this->request->post['module_generator_invoice_min'])) || ($this->request->post['module_generator_invoice_min'] < 1) || ($this->request->post['module_generator_invoice_min'] > 999)) {
            $this->error['module_generator_invoice_min'] = $this->language->get('error_number');
        }

        if ((!preg_match('/^[0-9]*$/', $this->request->post['module_generator_invoice_max'])) || ($this->request->post['module_generator_invoice_max'] < 1) || ($this->request->post['module_generator_invoice_max'] > 999)) {
            $this->error['module_generator_invoice_max'] = $this->language->get('error_number');
        }

        if ($this->request->post['module_generator_order_min'] > $this->request->post['module_generator_order_max']) {
            $this->error['module_generator_order_min'] = $this->language->get('error_maximum');
            $this->error['module_generator_order_max'] = $this->language->get('error_maximum');
        }

        if ($this->request->post['module_generator_invoice_min'] > $this->request->post['module_generator_invoice_max']) {
            $this->error['module_generator_invoice_min'] = $this->language->get('error_maximum');
            $this->error['module_generator_invoice_max'] = $this->language->get('error_maximum');
        }

		return !$this->error;
	}
}
