<?php
class ControllerExtensionModuleMeproductvideo extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/me_product_video');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		$this->load->model('extension/me_product_video');
		$this->model_extension_me_product_video->Createtable();

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_me_product_video', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->error['width'])) {
			$data['error_width'] = $this->error['width'];
		} else {
			$data['error_width'] = '';
		}

		if (isset($this->error['height'])) {
			$data['error_height'] = $this->error['height'];
		} else {
			$data['error_height'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/me_product_video', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/me_product_video', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		###  Get All Languages
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		
		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->request->post['module_me_product_video_status'])) {
			$data['module_me_product_video_status'] = $this->request->post['module_me_product_video_status'];
		} else {
			$data['module_me_product_video_status'] = $this->config->get('module_me_product_video_status');
		}
		
		if (isset($this->request->post['module_me_product_video_thumbnail'])) {
			$data['module_me_product_video_thumbnail'] = $this->request->post['module_me_product_video_thumbnail'];
		} else {
			$data['module_me_product_video_thumbnail'] = $this->config->get('module_me_product_video_thumbnail');
		}
		
		$this->load->model('tool/image');

		if (isset($this->request->post['module_me_product_video_thumbnail']) && is_file(DIR_IMAGE . $this->request->post['module_me_product_video_thumbnail'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['module_me_product_video_thumbnail'], 100, 100);
		} elseif (!empty($data['module_me_product_video_thumbnail']) && is_file(DIR_IMAGE . $data['module_me_product_video_thumbnail'])) {
			$data['thumb'] = $this->model_tool_image->resize($data['module_me_product_video_thumbnail'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		
		if (isset($this->request->post['module_me_product_video_show_video'])) {
			$data['module_me_product_video_show_video'] = $this->request->post['module_me_product_video_show_video'];
		} else {
			$data['module_me_product_video_show_video'] = $this->config->get('module_me_product_video_show_video');
		}
		
		if (isset($this->request->post['module_me_product_video_display'])) {
			$data['module_me_product_video_display'] = $this->request->post['module_me_product_video_display'];
		} else {
			$data['module_me_product_video_display'] = $this->config->get('module_me_product_video_display');
		}
		
		if (isset($this->request->post['module_me_product_video_autoplay'])) {
			$data['module_me_product_video_autoplay'] = $this->request->post['module_me_product_video_autoplay'];
		} else {
			$data['module_me_product_video_autoplay'] = $this->config->get('module_me_product_video_autoplay');
		}
		
		if (isset($this->request->post['module_me_product_video_controls'])) {
			$data['module_me_product_video_controls'] = $this->request->post['module_me_product_video_controls'];
		} else {
			$data['module_me_product_video_controls'] = $this->config->get('module_me_product_video_controls');
		}
		
		if (isset($this->request->post['module_me_product_video_position'])) {
			$data['module_me_product_video_position'] = $this->request->post['module_me_product_video_position'];
		} else {
			$data['module_me_product_video_position'] = $this->config->get('module_me_product_video_position');
		}
		
		if (isset($this->request->post['module_me_product_video_popup_width'])) {
			$data['module_me_product_video_popup_width'] = $this->request->post['module_me_product_video_popup_width'];
		} elseif($this->config->get('module_me_product_video_popup_width')) {
			$data['module_me_product_video_popup_width'] = $this->config->get('module_me_product_video_popup_width');
		}else{
			$data['module_me_product_video_popup_width'] = '800';
		}
		
		if (isset($this->request->post['module_me_product_video_popup_height'])) {
			$data['module_me_product_video_popup_height'] = $this->request->post['module_me_product_video_popup_height'];
		} elseif($this->config->get('module_me_product_video_popup_height')) {
			$data['module_me_product_video_popup_height'] = $this->config->get('module_me_product_video_popup_height');
		}else{
			$data['module_me_product_video_popup_height'] = '500';
		}
		
		if (isset($this->request->post['module_me_product_video_desc'])) {
			$data['module_me_product_video_desc'] = $this->request->post['module_me_product_video_desc'];
		} else {
			$data['module_me_product_video_desc'] = $this->config->get('module_me_product_video_desc');
		}
		
		if (isset($this->request->post['module_me_product_video_common'])) {
			$module_me_product_videos = $this->request->post['module_me_product_video_common'];
		} elseif($this->config->get('module_me_product_video_common')) {
			$module_me_product_videos = $this->config->get('module_me_product_video_common');
		}else{
			$module_me_product_videos = array();
		}
		
		$data['module_me_product_videos'] = array();
		
		$this->load->model('catalog/category');
		$this->load->model('catalog/manufacturer');
		
		foreach($module_me_product_videos as $module_me_product_video){
			if (is_file(DIR_IMAGE . $module_me_product_video['image'])) {
				$image = $module_me_product_video['image'];
				$thumb = $module_me_product_video['image'];
			} else {
				$image = '';
				$thumb = 'no_image.png';
			}
			
			$product_category = array();
			if($module_me_product_video['assignto'] == 2 && isset($module_me_product_video['product_category'])){
				foreach($module_me_product_video['product_category'] as $category_id){
					$category_info = $this->model_catalog_category->getCategory($category_id);

					if ($category_info) {
						$product_category[] = array(
							'category_id' => $category_info['category_id'],
							'name'        => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
						);
					}
				}
			}
			
			$product_manufacturer = array();
			if($module_me_product_video['assignto'] == 3 && isset($module_me_product_video['product_manufacturer'])){
				foreach($module_me_product_video['product_manufacturer'] as $manufacturer_id){
					$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($manufacturer_id);

					if ($manufacturer_info) {
						$product_manufacturer[] = array(
							'manufacturer_id' => $manufacturer_info['manufacturer_id'],
							'name'        => $manufacturer_info['name']
						);
					}
				}
			}
			
			$data['module_me_product_videos'][] = array(
				'image'      => $image,
				'thumb'      => $this->model_tool_image->resize($thumb, 100, 100),
				'video_type' => $module_me_product_video['video_type'],
				'video_link' => $module_me_product_video['video_link'],
				'assignto' => $module_me_product_video['assignto'],
				'status' => isset($module_me_product_video['status']) ? $module_me_product_video['status'] : 0,
				'sort_order' => !empty($module_me_product_video['sort_order']) ? $module_me_product_video['sort_order'] : 0,
				'product_category' => $product_category,
				'product_manufacturer' => $product_manufacturer,
			);
		}
		
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/me_product_video', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/me_product_video')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['module_me_product_video_popup_width']) {
			$this->error['width'] = $this->language->get('error_width');
		}

		if (!$this->request->post['module_me_product_video_popup_height']) {
			$this->error['height'] = $this->language->get('error_height');
		}

		return !$this->error;
	}
	
	public function generatethumb(){
		$json = array();
		$this->load->model('tool/image');
		
		if(empty($this->request->post['video_link'])){
			$json['error'] = 'Empty Link';
		}
		
		if(!$json){
			if($this->request->post['video_type'] == 1){
				$video_id = $this->getYoutubeId($this->request->post['video_link']);	
				if($video_id){
					$imagepath = DIR_IMAGE.'catalog/'.$video_id.'.jpg';
					file_put_contents($imagepath, file_get_contents("https://img.youtube.com/vi/$video_id/0.jpg"));
					$thumb = 'catalog/'.$video_id.'.jpg';
				}else{
					$thumb = 'no_image.png';
				}
				
				if($thumb){
					$json['video_thumb'] = $this->model_tool_image->resize($thumb, 100, 100);
					$json['video_image'] = $thumb;
				}else{
					$json['video_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
					$json['video_image'] = '';
				}
			}elseif($this->request->post['video_type'] == 2){
				$video_id = $this->getVimeoId($this->request->post['video_link']);
				if($video_id){
					$imagepath = DIR_IMAGE.'catalog/'.$video_id.'.jpg';
					$imagedata = unserialize(file_get_contents("http://vimeo.com/api/v2/video/$video_id.php"));
					$videoimagepath = isset($imagedata[0]['thumbnail_large']) ? $imagedata[0]['thumbnail_large'] : '';
					
					file_put_contents($imagepath, file_get_contents($videoimagepath));
					$thumb = 'catalog/'.$video_id.'.jpg';
				}else{
					$thumb = 'no_image.png';
				}
				
				if($thumb){
					$json['video_thumb'] = $this->model_tool_image->resize($thumb, 100, 100);
					$json['video_image'] = $thumb;
				}else{
					$json['video_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
					$json['video_image'] = '';
				}
			}elseif($this->request->post['video_type'] == 3){
				$video_id =  $this->getDailyMotionId($this->request->post['video_link']);
				if($video_id){
					$imagepath = DIR_IMAGE.'catalog/'.$video_id.'.jpg';
				
					$imagedata = json_decode(file_get_contents("https://api.dailymotion.com/video/$video_id?fields=thumbnail_360_url"));
					$videoimagepath = isset($imagedata->thumbnail_360_url) ? $imagedata->thumbnail_360_url : '';
					file_put_contents($imagepath, file_get_contents($videoimagepath));
					$thumb = 'catalog/'.$video_id.'.jpg';
				}else{
					$thumb = 'no_image.png';
				}
				
				if($thumb){
					$json['video_thumb'] = $this->model_tool_image->resize($thumb, 100, 100);
					$json['video_image'] = $thumb;
				}else{
					$json['video_thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
					$json['video_image'] = '';
				}
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function getYoutubeId($url){

		$parts = parse_url($url);
		if (isset($parts['host'])) {
			$host = $parts['host'];
			if (
				false === strpos($host, 'youtube') &&
				false === strpos($host, 'youtu.be')
			) {
				return false;
			}
		}
		if (isset($parts['query'])) {
			parse_str($parts['query'], $qs);
			if (isset($qs['v'])) {
				return $qs['v'];
			}
			else if (isset($qs['vi'])) {
				return $qs['vi'];
			}
		}
		if (isset($parts['path'])) {
			$path = explode('/', trim($parts['path'], '/'));
			return $path[count($path) - 1];
		}
		return false;
	}
	
	public function getDailyMotionId($url){
		if (preg_match('!^.+dailymotion\.com/(video|hub)/([^_?]+)[^#]*(#video=([^_&]+))?|(dai\.ly/([^_?]+))!', $url, $m)) {
			if (isset($m[6])) {
				return $m[6];
			}
			if (isset($m[4])) {
				return $m[4];
			}
			return $m[2];
		}
		return false;
	}
	
	public function getVimeoId($url) {
		if (preg_match('#(?:https?://)?(?:www.)?(?:player.)?vimeo.com/(?:[a-z]*/)*([0-9]{6,11})[?]?.*#', $url, $m)) {
			return $m[1];
		}
		return false;
	}
	
	public function upload() {
		$this->load->language('catalog/download');

		$json = array();

		// Check user has permission
		if (!$this->user->hasPermission('modify', 'catalog/download')) {
			$json['error'] = $this->language->get('error_permission');
		}

		if (!$json) {
			if (!empty($this->request->files['file']['name']) && is_file($this->request->files['file']['tmp_name'])) {
				// Sanitize the filename
				$filename = str_replace(' ', '-',basename(html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8')));
				
				// Validate the filename length
				if ((utf8_strlen($filename) < 3) || (utf8_strlen($filename) > 128)) {
					$json['error'] = $this->language->get('error_filename');
				}

				// Allowed file extension types
				$allowed = array();

				$filetypes = array('mp4','mov','wmv','avi','webm');

				foreach ($filetypes as $filetype) {
					$allowed[] = trim($filetype);
				}

				if (!in_array(strtolower(substr(strrchr($filename, '.'), 1)), $allowed)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Allowed file mime types
				$allowed = array();

				$filetypes = array('video/mp4','video/mov','video/x-ms-wmv','video/avi','video/webm');
				
				foreach ($filetypes as $filetype) {
					$allowed[] = trim($filetype);
				}
				
				if (!in_array($this->request->files['file']['type'], $allowed)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Check to see if any PHP files are trying to be uploaded
				$content = file_get_contents($this->request->files['file']['tmp_name']);

				if (preg_match('/\<\?php/i', $content)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Return any upload error
				if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
					$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
				}
			} else {
				$json['error'] = $this->language->get('error_upload');
			}
		}

		if (!$json) {
			$file = token(32) . '.' . $filename;
			
			$site_path = str_replace('catalog/','',DIR_CATALOG);
			
			if(!file_exists($site_path.'uploaded_videos')){
				mkdir($site_path.'uploaded_videos');
			}
			
			$xfile = $site_path.'uploaded_videos/'.$file;
			move_uploaded_file($this->request->files['file']['tmp_name'], $xfile);

			$json['filename'] = $file;
			$json['mask'] = $filename;

			$json['success'] = $this->language->get('text_upload');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}