<?php
class ControllerExtensionModuleOrdercoupon extends Controller {
    use OCM\Traits\Back\Controller\Common;
    use OCM\Traits\Back\Controller\Product;
    use OCM\Traits\Back\Controller\Util;
    use OCM\Traits\Back\Controller\Coupon;
    use OCM\Traits\Back\Controller\Curl;
    private $ext_path;
    private $ext_key;
    private $error = array();
    private $ocm;
    private $meta = array(
        'id'       => '39462',
        'type'     => 'module',
        'name'     => 'ordercoupon',
        'path'     => 'extension/module/',
        'title'    => 'Auto Coupon On Purchase',
        'version'  => '1.1.2',
        'ocmod'    => true,
        'event'    => true
    );
    /* Config with default values  Special keyword __LANG__ denotes array of languages e.g 'name' => array('__LANG__' => 'xyz') */
    private $setting = array(
        'ordercoupon_status' => ''
    );
    private $events = array(
        array(
            'trigger' => 'admin/view/common/column_left/before',
            'action'  => 'extension/module/ordercoupon/onColumnLeft'
        )
    );
    private $tables = array(
        'ordercoupon_setting' => array(
            array('name'=> 'general', 'option' => 'text'),
            array('name'=> 'sms_body', 'option' => 'text')
        ),
        'ordercoupon_coupon' => array()
    );
    public function __construct($registry) {
        parent::__construct($registry);
        $this->meta['ocmod'] = VERSION < '2.2.0.0';
        $this->ocm = new OCM\Back($registry, $this->meta);
        $this->ext_path = $this->meta['path'] . $this->meta['name'];
        $this->ext_key = 'model_' . str_replace('/', '_', $this->ext_path);
    }
    public function index() {
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/setting');

        $data = array();
        $data = array_merge($data, $ext_lang);

        /* লাইসেন্স বেরিফিকেসন  */
        $rs = $this->ocm->rpd();
        $data['_v'] = $rs ? '' : $this->ocm->vs();
        /* লাইসেন্স শেষ */
        $this->ocm->checkOCMOD();
        $this->upgrade();

        $data['heading_title'] = $this->language->get('heading_title');
        $data['x_name'] = $this->meta['name'];
        $data['x_path'] = $this->meta['path'] . $this->meta['name'];

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->session->data['warning'])) {
            $data['error_warning'] = $this->session->data['warning'];
            unset($this->session->data['warning']);
        }
        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
        
        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'r.date_added';
        }
        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }
        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }
        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = '';
        }
        if (isset($this->request->get['filter_coupon'])) {
            $filter_coupon = $this->request->get['filter_coupon'];
        } else {
            $filter_coupon = '';
        }
        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = '';
        }
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }
        
        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        $filter_url = '';
        if (isset($this->request->get['filter_name'])) {
            $filter_url .= '&filter_name=' . $this->request->get['filter_name'];
        }
        if (isset($this->request->get['filter_email'])) {
            $filter_url .= '&filter_email=' . $this->request->get['filter_email'];
        }
        if (isset($this->request->get['filter_date_from'])) {
            $filter_url .= '&filter_date_from=' . urlencode(html_entity_decode($this->request->get['filter_date_from'], ENT_QUOTES, 'UTF-8'));
        }
        if (isset($this->request->get['filter_date_to'])) {
            $filter_url .= '&filter_date_to=' . urlencode(html_entity_decode($this->request->get['filter_date_to'], ENT_QUOTES, 'UTF-8'));
        }
        if (isset($this->request->get['filter_coupon'])) {
            $filter_url .= '&filter_coupon=' . $this->request->get['filter_coupon'];
        }
        if (isset($this->request->get['filter_order_id'])) {
            $filter_url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        $url = $filter_url;
        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
        
        $data['sort_name'] = $this->ocm->url->link($this->ext_path, 'sort=customer_name' . $url, true);
        $data['sort_email'] = $this->ocm->url->link($this->ext_path, 'sort=customer_email' . $url, true);
        $data['sort_date'] = $this->ocm->url->link($this->ext_path, 'sort=r.date_added' . $url, true);

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href' => $this->ocm->url->link('common/dashboard', '', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->ocm->url->getExtensionsURL()
        );
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->ocm->url->getExtensionURL()
        );

        $data['setting'] = $this->ocm->url->link($this->ext_path .'/setting', '', true);
        $data['action'] = $this->ocm->url->link($this->ext_path . '/delete', '', true);
        $data['export'] = $this->ocm->url->link($this->ext_path . '/export', '', true);

        $filter_data = array(
            'sort'  => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_email' => $filter_email,
            'filter_coupon' => $filter_coupon,
            'filter_order_id' => $filter_order_id,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $results = $this->{$this->ext_key}->getCoupons($filter_data);
        $data['coupons'] = array();
        foreach ($results as $result) {
            $amount = $result['type'] == 'P' ? $result['discount'].'%' : $result['discount'];
            $data['coupons'][] = array(
                'coupon_id'             => $result['coupon_id'],
                'customer_name'         => $result['customer_name'],
                'customer_email'        => $result['customer_email'],
                'order_id'              => $result['order_id'],
                'coupon_code'           => $result ? $result['code'] : '',
                'amount'                => $amount,
                'date_added'            => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'order'                => $this->ocm->url->link('sale/order/info',  'order_id=' . $result['order_id'] . $url, true),
                'action'                => $this->ocm->url->link('marketing/coupon/edit', 'coupon_id=' . $result['coupon_id'] . $url, true)
            );
        }
        $coupons_total = $this->{$this->ext_key}->getTotalCoupons($filter_data);
        
        $url = $filter_url;
        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }
        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $coupons_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->ocm->url->link($this->ext_path, $url . '&page={page}', true);
        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($coupons_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($coupons_total - $this->config->get('config_limit_admin'))) ? $coupons_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $coupons_total, ceil($coupons_total / $this->config->get('config_limit_admin')));
        
        $data['filter_name'] = $filter_name;
        $data['filter_email'] = $filter_email;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_coupon'] = $filter_coupon;
        $data['filter_order_id'] = $filter_order_id;
        $data['sort'] = $sort;
        $data['order'] = strtolower($order);
        $data['oc_3_1'] = VERSION >= '3.1.0.0';
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->ocm->view($this->ext_path, $data));
    }
    public function delete() {
       $this->load->language($this->ext_path);
       $this->load->model($this->ext_path);

       if($this->request->post && isset($this->request->post['selected']) && $this->request->post['selected']) {
              $selected = $this->request->post['selected'];
              if($selected && is_array($selected)) {
                   foreach($selected as $coupon_id) {
                      $this->{$this->ext_key}->deleteCoupon($coupon_id);
                   }
              }
        }
        $this->session->data['success'] = $this->language->get('text_success');
        $this->response->redirect($this->ocm->url->link($this->ext_path, '', true)); 
    }
    public function setting() {
        $ext_lang = $this->load->language($this->ext_path);
        $this->load->model($this->ext_path);
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');
        $data = array();
        $data = array_merge($data, $ext_lang);
        $data['x_name'] = $this->meta['name'];
        $data['x_path'] = $this->meta['path'] . $this->meta['name'];
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $save = array();
            $general = isset($this->request->post['general']) ? $this->request->post['general'] : array();
            if (isset($this->request->post['curl'])) {
                $general['curl'] = $this->request->post['curl'];
            }
            $save['general'] = $general;
            $save['discount'] = isset($this->request->post['discount']) ? $this->request->post['discount'] : array();
            $save['coupon'] = $this->request->post['coupon'];
            $save['email_subject'] = $this->request->post['email_subject'];
            $save['email_body'] = $this->request->post['email_body'];
            $save['sms_body'] = $this->request->post['sms_body'];
            $this->{$this->ext_key}->addCouponSetting($save);

            /* save config */
            $save = $this->ocm->setting->editSetting($this->setting);
            $this->model_setting_setting->editSetting($save['key'], $save['value']);

            $this->session->data['success'] = $this->language->get('text_success');

            $redirect = $this->request->post['save'] == 'continue' ? $this->ocm->url->link($this->ext_path . '/setting', '', true) : $this->ocm->url->getExtensionURL();
            $this->response->redirect($redirect);
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href' => $this->ocm->url->link('common/dashboard', '', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->ocm->url->getExtensionsURL()
        );
        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->ocm->url->getExtensionURL()
        );
    
        $data['action'] = $this->ocm->url->link($this->ext_path . '/setting', '', true);
        $data['cancel'] = $this->ocm->url->link($this->ext_path, '', true);

        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();
        $data['languages'] = $this->ocm->url->getLangImage($languages);
        $data['language_id'] = $this->config->get('config_language_id');

        $defaults = array(
            'general' => array(
                'sms'  => '',
                'curl' => $this->getDefaultCurlParams()
            ),
            'discount' => array(),
            'coupon' => $this->getCouponDefault()
        );

        $setting = $this->{$this->ext_key}->getSetting();
        $setting = $this->setDefault($setting, $defaults);

        $data['general'] = $setting['general'];
        $data['coupon'] = $setting['coupon'];
        $data['discount'] = $setting['discount'];
        $data['email_subject'] = $setting['email_subject'];
        $data['email_body'] = $setting['email_body'];
        $data['sms_body'] = $setting['sms_body'];

        if (!isset($data['general']['complete_status']) || !is_array($data['general']['complete_status'])) {
           $data['general']['complete_status'] = $this->config->get('config_complete_status');
        }

        /* Set Default values */
        $lang_fields = array(
            'email_subject'    => $this->language->get('text_email_subject'),
            'email_body'       => $this->language->get('text_email_body'),
            'sms_body'         => $this->language->get('text_sms_body'),
        );
        $data = $this->setDefaultByLangs($data, $languages, $lang_fields);

        $product_rules = array('product', 'category');
        foreach ($product_rules as $key) {
            if (!isset($data['coupon'][$key]) || !is_array($data['coupon'][$key])) {
                $data['coupon'][$key] = array();
            }
        }

        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        array_unshift($stores, array('store_id' => 0,'name' => $this->language->get('text_default')));
        $options['store'] = $this->ocm->form->getOptions($stores, 'store_id');

        $yes_no_options = array('1' => $data['text_yes'], '0' => $data['text_no']);
        $options['logged'] = $options['shipping'] = $this->ocm->form->getOptions($yes_no_options, 'none');

        $status_option = array('1' => $data['text_enabled'], '0' => $data['text_disabled']);
        $options['status'] = $this->ocm->form->getOptions($status_option, 'none');

        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $options['complete_status'] = $this->ocm->form->getOptions($order_statuses, 'order_status_id');

        $start_type_option = array('auto' => $data['text_start_current'], 'manual' => $data['text_start_manual']);
        $options['start_type'] = $this->ocm->form->getOptions($start_type_option, 'none');

        $coupon_expire_type_option = array('D' => $data['text_day'], 'W' => $data['text_week'], 'M' => $data['text_month']);
        $options['coupon_expire_type'] = $this->ocm->form->getOptions($coupon_expire_type_option, 'none');
        $options['xcoupon_id'] = $this->ocm->form->getOptions($this->getXCouponGroups(), 'none');
        $this->ocm->form->setLangs($ext_lang)->setOptions($options);

        $data['site_url'] = $this->ocm->common->getSiteURL();
        $placeholders = array(
            '<input value="{firstName}" class="ocm-placeholder">'     => 'Customer First Name',
            '<input value="{lastName}" class="ocm-placeholder">'      => 'Customer Last Name',
            '<input value="{fullName}" class="ocm-placeholder">'      => 'Customer Name',
            '<input value="{email}" class="ocm-placeholder">'         => 'Sender Email',
            '<input value="{orderId}" class="ocm-placeholder">'       => 'Order ID',
            '<input value="{storeName}" class="ocm-placeholder">'     => 'Store name',
            '<input value="{storeUrl}" class="ocm-placeholder">'      => 'Store URL',
            '<input value="{couponCode}" class="ocm-placeholder">'    => 'Coupon Code',
            '<input value="{couponValue}" class="ocm-placeholder">'   => 'Coupon amount'
        );
        $placeholders_formatted = $this->getPlaceholderList($placeholders);
        

        $more_help = array();
        $more_help['email_body'] = $more_help['sms_body'] = $placeholders_formatted;
        $data['more_help'] = json_encode($more_help);

        $data['oc_3_1'] = VERSION >= '3.1.0.0';
        $data['editor_js'] = VERSION >= '2.3.0.0';
        $data['config'] = $this->getConfigForm($data);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->ocm->view($this->ext_path . '_setting', $data));
    }
    private function getConfigForm($data){
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('catalog/manufacturer');

        /* Set base name for form inputs */
        $this->ocm->form->setIDPostfix('');
        $setting = $this->ocm->setting->getSetting($this->setting, $data['languages']);
        $return = '';
        $tabs = array(
            'tab-general' => $data['tab_general'],
            'tab-coupon'  => $data['tab_coupon'],
            'tab-discount'=> $data['tab_discount'],
            'tab-email'   => $data['tab_text'],
            'tab-sms'     => $data['tab_sms'],
            'tab-help'    => $data['tab_help']
        );
        $return .= $this->ocm->misc->getTabs('config-tab', $tabs);
        $return .= '<div class="tab-content">';

        $return .= '<div class="tab-pane active" id="tab-general">';
        // oc setting 
        $config = $this->ocm->setting->getSetting($this->setting, $data['languages']);
        $this->ocm->form->setBasename($this->ocm->prefix . 'ordercoupon_', 'prefix');
        $this->ocm->form->setPreset($config);
        $return .= $this->ocm->form->get('select', 'status');
        
        $this->ocm->form->setPreset($data['general']);
        $this->ocm->form->setBasename('general');
        $return .= $this->ocm->form->get('checkgroup', array('name' => 'complete_status[]', 'all' => false));
        $return .= $this->ocm->form->get('checkbox', array('name' => 'sms', 'label' => $data['text_sms']));
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="tab-coupon">';
        $this->ocm->form->setPreset($data['coupon']);
        $this->ocm->form->setBasename('coupon');
        $return .= $this->getCouponForm($data['coupon'], false);
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="tab-discount">';
        $return .= $this->geteDiscountData($data);
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="tab-email">';
        $return .= $this->ocm->misc->getLangTabs('language_heading', $data['languages']);
        $return .= '<div class="tab-content">';

        $this->ocm->form->setPreset($data);
        $this->ocm->form->setBasename('','prefix');

        $active = ' active';

        foreach ($data['languages'] as $language) {
            $language_id = $language['language_id'];
            $return .= '<div class="tab-pane' . $active . '" id="language_heading' . '-' . $language_id . '">';

            $param = array(
                'name'    => 'email_subject['. $language_id . ']'
            );
            $return .= $this->ocm->form->get('input', $param);
            
            $param = array(
                'name'    => 'email_body['. $language_id . ']',
                'class'   => 'editor'
            );
            $return .= $this->ocm->form->get('textarea', $param);

            $param = array(
                'name'    => 'sms_body['. $language_id . ']',
                'class'   => 'ocm-hide',
                'attr'    => 'sms',
                'visible' => $data['general']['sms']
            );
            $return .= $this->ocm->form->get('textarea', $param);

            $return .= '</div>';
            $active = '';
        }
        
        $return .= '</div>';
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="tab-sms">';
        $this->ocm->form->setBasename('', 'prefix');
        $curl = $data['general']['curl'];
        $curl_placeholders = '<b>Available Placeholders Are:</b> {mobile}, {message} </br> </br>';
        $return .= $this->curlTab($curl, $curl_placeholders, true, true);
        $return .= '</div>';

        $return .= '<div class="tab-pane" id="tab-help">';
        $return .= $this->ocm->misc->getOCMInfo();
        $return .= '</div>';
        $return .= '</div>';
        return $return;
    }
    private function geteDiscountData($data) {
        $fields = array('start', 'end', 'cost');
        $return = '';
        $ranges = array();
        foreach ($data['discount'] as $counter => $range) {
            foreach ($fields as $field) {
                if (!isset($range[$field])) {
                    $range[$field] = '';
                }
            }
            $ranges[] = $range;
        }
        $table_body = '';
        foreach ($ranges as $counter => $range) {
            $table_body .= '<tr rel="'.$counter.'">' 
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="discount['.$counter.'][start]" value="' . $range['start'] . '" /></td>'
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="discount['.$counter.'][end]" value="' . $range['end'] . '" /></td>'
                            .'<td class="text-left"><input size="15" type="text" class="form-control" name="discount['.$counter.'][cost]" value="' . $range['cost'] . '" /></td>'
                            .'<td class="text-right"><a class="btn btn-sm btn-danger ocm-row-remove">'.$data['text_remove'].'</a></td>'
                        .'</tr>';
        }
        if (!$data['discount']) $table_body .= '<tr class="no-row"><td colspan="4">'.$data['text_no_unit_row'].'</td></tr>';

        $table_headings = array(
            array(
                'title'  => $data['text_start']
            ),
            array(
                'title'  => $data['text_end']
            ),
            array(
                'title' => $data['text_cost']
            ),
            array(
                'title' => $data['text_action']
            )
        );

        $table_footer = '<tfoot>
                           <td colspan="7" class="text-right">&nbsp;';
        $table_footer .= $this->ocm->misc->getButton(array('type' => 'primary', 'title'=> $data['text_add_new'], 'class' => 'add-ocm-row', 'icon' => 'fa-plus-circle'));
        $table_footer .= '</tr>
                        </tfoot>';

        $return .= $this->ocm->misc->getTableSkeleton($table_headings, $table_body, $table_footer);
        return $return;
    }
    public function export() {
        $this->load->model($this->ext_path);
        $filter_data = array();
        $results = $this->{$this->ext_key}->getCoupons($filter_data);
        $fields = array('coupon_id','customer_id', 'customer_name', 'customer_email', 'order_id', 'date_added');
        $content = $this->ocm->misc->getCSV($results, $fields);
        $filename = 'coupons.csv';
        $this->forceDownload($content, $filename);
    }
    public function onColumnLeft($route, &$data) {
        if (VERSION >= '2.3.0,0') {
            $menu = array(
                'id'       => 'menu-ordercoupon',
                'icon'     => ' fa-bullseye', 
                'name'     => $this->meta['title'],
                'href'     => $this->ocm->url->link($this->ext_path, '', true),
                'children' => array()
            );
            array_push($data['menus'], $menu);
        }
    }
}