<?php

use Advertikon\Element\Bootstrap\Button;
/**
 * Admin Advertikon Stripe Controller
 *
 * @author Advertikon
 * @package Stripe
 * @version 5.0.44  
 *
 * @source catalog/view/javascript/advertikon/adk.js
 * @source catalog/view/javascript/advertikon/alert.js
 * @source catalog/view/javascript/advertikon/animate_css.js
 * @source catalog/view/javascript/advertikon/button.js
 * @source catalog/view/javascript/advertikon/fancy_checkbox.js
 * @source catalog/view/javascript/advertikon/form.js
 * @source catalog/view/javascript/advertikon/iris.min.js
 * @source catalog/view/javascript/advertikon/iris.js
 * @source catalog/view/javascript/advertikon/jquery-ui.min.js
 * @source catalog/view/javascript/advertikon/jquery_private.js
 * @source catalog/view/javascript/advertikon/notification.js
 * @source catalog/view/javascript/advertikon/qrcode/jquery-qrcode.min.js
 * @source catalog/view/javascript/advertikon/require.js
 * @source catalog/view/javascript/advertikon/select2.js
 * @source catalog/view/javascript/advertikon/slider.js
 * @source catalog/view/javascript/advertikon/support.js
 * @source catalog/view/javascript/advertikon/switcher.js
 * @source catalog/view/javascript/advertikon/translator.js
 * @source catalog/view/javascript/advertikon/ui_init.js
 *
 * @source catalog/view/javascript/advertikon/select2/*
 *
 * @source admin/view/javascript/advertikon/stripe/*
 *
 * @source catalog/view/theme/default/stylesheet/advertikon/animate.min.css
 * @source catalog/view/theme/default/stylesheet/advertikon/advertikon.css
 *
 * #@source admin/view/stylesheet/advertikon/jquery-ui.min.css
 * #@source admin/view/stylesheet/advertikon/jquery-ui.theme.min.css
 * #@source admin/view/stylesheet/advertikon/images/* jQuery-IU images
 * @source admin/view/stylesheet/advertikon/select2/select2.min.css
 * @source admin/view/stylesheet/advertikon/spectrum.css
 * @source admin/view/stylesheet/advertikon/stripe/*
 *
 * @source image/catalog/advertikon/refresh_modification.png
 * @source image/catalog/advertikon/enable_modification.png
 *
 * @source admin/view/template/extension/payment/advertikon/stripe/*
 *
 * @source system/library/advertikon/accounts.php
 * @source system/library/advertikon/account.php
 * @source system/library/advertikon/address.php
 * @source system/library/advertikon/advertikon.php
 * @source system/library/advertikon/array_iterator.php #query
 * @source system/library/advertikon/browscap.php
 * @source system/library/advertikon/cache.php
 * @source system/library/advertikon/compatibility_check.php
 * @source system/library/advertikon/console.php
 * @source system/library/advertikon/customer.php
 * @source system/library/advertikon/db_result.php #query
 * @source system/library/advertikon/exception.php
 * @source system/library/advertikon/fs.php
 * @source system/library/advertikon/language.php
 * @source system/library/advertikon/load.php
 * @source system/library/advertikon/oc_cert.pem
 * @source system/library/advertikon/option.php
 * @source system/library/advertikon/order.php
 * @source system/library/advertikon/parser.php #query
 * @source system/library/advertikon/query.php #query
 * @source system/library/advertikon/renderer.php
 * @source system/library/advertikon/sessionmessage.php
 * @source system/library/advertikon/setting.php
 * @source system/library/advertikon/shortcode.php
 * @source system/library/advertikon/sql.php
 * @source system/library/advertikon/store.php
 * @source system/library/advertikon/translator.php
 * @source system/library/advertikon/twig.php
 * @source system/library/advertikon/update.php
 * @source system/library/advertikon/url.php
 *
 * @source system/library/advertikon/element/*
 * @source system/library/advertikon/exception/*
 * @source system/library/advertikon/parser/* #query
 * @source system/library/advertikon/sql/*
 * @source system/library/advertikon/Twig/*
 *
 * @source system/library/advertikon/stripe/*
 *
 * @source system/library/advertikon/trait_update.php
 * @source system/library/advertikon/trait_support.php
 * @source system/library/advertikon/trait_controller.php
 * @source system/library/advertikon/trait_translate.php
 *
 * @source system/library/advertikon/interface_admin_controller.php
 *
 * @source system/library/advertikon/vendor/autoload.php
 * @source system/library/advertikon/vendor/composer/*
 * @source system/library/advertikon/vendor/twig/*
 * @source system/library/advertikon/vendor/symfony/*
 * @source system/library/advertikon/vendor/stripe/*
 */

use Advertikon\Element\Italic;
use Advertikon\Element\Bootstrap\Label;
use Advertikon\Element\Bootstrap\Message;
use Advertikon\Element\Span;
use Advertikon\SessionMessage;
use Advertikon\Setting;
use Advertikon\Stripe\Advertikon;
use Advertikon\Stripe\Extended;
use Advertikon\Stripe\Order;
use Advertikon\Stripe\OrderPrice;
use Advertikon\Stripe\PaymentOption;

class ControllerExtensionPaymentAdvertikonStripe extends Controller implements \Advertikon\Interface_Admin_Controller {
         
	use \Advertikon\Trait_Update;
	use \Advertikon\Trait_Support;
	use \Advertikon\Trait_Translate;
	use \Advertikon\Trait_Controller;

	/** @var Advertikon/Stripe/Advertikon */
	public $a = null;

	/** @var ModelExtensionPaymentAdvertikonStripe  */
	public $model = null;

	/**
	 * ControllerExtensionPaymentAdvertikonStripe constructor.
	 * @param $registry
	 * @throws \Advertikon\Exception
	 */
	public function __construct( $registry ) {
		parent::__construct( $registry );
		$this->a = Advertikon::instance( $registry );
		$this->model = $this->a->load->model( $this->a->full_name );
		$this->a->init_traits( $this );
		$this->a->updateBrowscap();
	}

	/**
	 * indexAction
	 * @return void
	 * @throws \Advertikon\Exception
	 * @throws Exception
	 */
	public function index() {
		$this->document->addStyle( $this->a->u()->admin_css( 'advertikon/jquery-ui.min.css' ) );
		$this->document->addStyle( $this->a->u()->admin_css( 'advertikon/jquery-ui.theme.min.css' ) );
		$this->document->addStyle( $this->a->u()->admin_css( 'advertikon/select2/select2.min.css' ) );
		$this->document->addStyle( $this->a->u()->catalog_css( 'advertikon/animate.min.css' ) );
		$this->document->addStyle( $this->a->u()->catalog_css( 'advertikon/advertikon.css' ) );
		$this->document->addStyle( $this->a->u()->admin_css( 'advertikon/spectrum.css' ) );
		$this->document->addStyle( $this->a->u()->admin_css( 'advertikon/stripe/adk_stripe.css' ) );

		//$data['requireJs'] = $this->a->requireJs( ['stripe/admin' => 'admin' ] );

		$this->document->setTitle( $this->a->__( 'Stripe Settings' ) );

		if ( version_compare( VERSION, '3', '>=' ) ) {
			$extension_route = 'marketplace/extension';

		} elseif ( version_compare( VERSION, '2.3', '>=' ) ) {
			$extension_route = 'extension/extension';

		} else {
			$extension_route = 'extension/' . $this->a->type;
		}

		$errors = [];

		if ( $this->request->server['REQUEST_METHOD'] == 'POST' ) {
            $errors = $this->model->validate_configs();

			if( !$errors ) {
				Setting::save_all( $this->request->post, $this->a );
				SessionMessage::add( $this->a->__( 'Settings has been successfully changed' ),Message::SUCCESS );
				$this->response->redirect( $this->a->u()->url() );
			}
		}

		if ( Setting::get( 'test_mode', $this->a ) ) {
			$data['testModeCaption'] = new Label( $this->a->__( 'Test mode' ), Label::WARNING );
		}

		if ( !Setting::get( 'status', $this->a ) ) {
			$data['statusCaption'] = new Message( $this->a->__( 'The extension is disabled' ),Message::WARNING );
		}

		$errorTemplate = new Message( '', Message::WARNING );
		$errorTemplate->getClass( "error-message-template template" );
		$errorTemplate->children( new Italic() );
		$errorTemplate->style()->display( "none" );
		$data['errorMessageTemplate'] = $errorTemplate;

		$successTemplate = new Message( '', Message::SUCCESS );
		$successTemplate->getClass( "success-message-template template" );
		$successTemplate->children( new Italic() );
		$successTemplate->style()->display( "none" );
		$data['successMessageTemplate'] = $successTemplate;

		$data['requireJs'] = $this->a->requireJs( ['stripe/admin' => 'admin' ] );

		$data['messages'] = SessionMessage::showAll();

		$data['update_button'] = $this->get_update_button();
		$data['support'] = $this->render_support();
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->a->__( 'Home' ),
			'href' => $this->a->u( 'common/home' ),
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->a->__( 'Payment' ),
			'href' => $this->a->u( $extension_route	),
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->a->__( 'heading_title' ),
			'href' => $this->a->u( $this->a->full_name ),
		);

		$data['action'] = $this->a->u( $this->a->full_name );
		$data['cancel'] = $this->a->u( $extension_route );

		$data['compatibility'] = $this->a->check_compatibility();

		$data['version'] = $this->a->version();
		$data['header'] = $this->load->controller( 'common/header' );
		$data['footer'] = $this->load->controller( 'common/footer' );
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller( 'common/footer' );
		$data['a'] = $this->a; // TODO: ??????????
		$data['is_extended'] = $this->a->isExtended;
		$data['paymentOptions'] = PaymentOption::adminContent();

		$data = $this->model->get_controls( $data, $errors );
		$this->response->setOutput( $this->a->load->view( $this->a->get_template( $this->a->full_name ), $data ) );
	}

	/**
	 * Extension's installation method
	 * @return void
	 */
	public function install() {
		// Needs to be the first called in order to skip installation if modification is missing
//		if ( method_exists( $this, '_install' ) ) $this->_install();
//
//		// Some may use d_event_manager stuff
//		if ( property_exists( $this->model, 'create_tables' ) && is_callable( [ $this->model, 'create_tables'] ) ) {
//			$this->model->create_tables();
//
//		} else {
//			if ( method_exists( $this->model, 'create_tables' ) ) $this->model->create_tables();
//		}

		$this->model->create_tables();
	}

	/**
	 * Extension\'s uninstallation method
	 * @return void
	 */
	public function uninstall() {
		if ( method_exists( $this, '_uninstall' ) ) $this->_uninstall();

		// if ( \Advertikon\Setting::get( 'uninstall_clear_settings', $this->a ) ) {
		// 	$this->a->q( [
		// 		'query' => 'delete',
		// 		'table' => 'setting',
		// 		'where' => [
		// 			'field'     => '`key`',
		// 			'operation' => 'like',
		// 			'value'     => '%' . $this->a->get_prefix() . '%',
		// 		],
		// 	] );
		// }
	}

	/**
	 * Order details action
	 * @return void
	 * @throws \Advertikon\Exception
	 */
	public function ordershow() {
		$this->a->json_response( ['html' => $this->order() ] );
		//$this->response->setOutput( $this->order() );
	}

    /**
     * Display order details at admin area
     * @return string
     * @throws \Advertikon\Exception
     */
	public function order() {
		if ( !class_exists( 'Advertikon\Stripe\Extended' ) ) {
			return '';
		}

        $data = [];
		$locale = [];

        $this->document->addStyle( $this->a->u()->catalog_css( 'advertikon/advertikon.css' ) );

		try {
			Extended::order( $data, $locale );

			if ( version_compare( VERSION, '3', '>=' ) ) {
				$this->load->model('user/api');

				$api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

				if ($api_info && $this->user->hasPermission('modify', 'sale/order')) {
					$session = new Session($this->config->get('session_engine'), $this->registry);
					$session->start();

					if ( method_exists( $this->model_user_api, 'deleteApiSessionBySessonId' ) ) {
                        $this->model_user_api->deleteApiSessionBySessonId($session->getId());

                    } else if ( method_exists( $this->model_user_api, 'deleteApiSessionBySessionId' ) ) {
                        $this->model_user_api->deleteApiSessionBySessionId($session->getId());
                    }

					$this->model_user_api->addApiSession($api_info['api_id'], $session->getId(),
                        $this->request->server['REMOTE_ADDR']);

					$session->data['api_id'] = $api_info['api_id'];
					$locale['api_token'] = $session->getId();

				} else {
					$locale['api_token'] = '';
				}
			}

			$data['requireJs'] = $this->a->requireJs( ['stripe/admin_order' => 'order' ], [], $locale );

			$return =  $this->a->load->view(
				$this->a->get_template( $this->a->type . '/advertikon/stripe/order'	),
				$data
			);

		} catch( \Advertikon\Exception $e ) {
			$this->a->error( $e );
			$return  = sprintf( '<b>%s</b>: %s', $this->a->__( 'Unable to display order data' ), $e->getMessage() );

		} catch( \Exception $e ) {
			$this->a->error( $e );
			$return  = sprintf(
				'%s: <b>%s</b>',
				$this->a->__( 'Unable to display order data due to' ),
				$this->a->__( 'Script error' )
			);
		}

		return $return;
	}

	/**
	 * Capture payment from admin area action
	 * @return void
	 */
	public function capture() {
		$resp = array();

		try {
			$order_id = $this->a->requestParam( 'order_id', null );
			$amount   = $this->a->requestParam( 'amount', 0 );
			$notify   = $this->a->requestParam( 'notify', false );
			$override = $this->a->requestParam( 'overrode', false );

			if ( !$order_id ) {
				throw new \Advertikon\Exception( $this->a->__( 'Order ID is missing' ) );
			}

			$aOrder = \Advertikon\Stripe\Order::get( $order_id );

			if ( !$aOrder->exists() ) {
				throw new \Advertikon\Exception( $this->a->__( 'Order is missing' ) );
			}

			$aOrder->capture( $amount, $notify, $override );
			$resp['success'] = $this->a->__( 'Success' );

		} catch( \Advertikon\Exception $e ) {
			$resp['error'] = $e->getMessage();

		} catch( \Stripe\Error\Base $e ) {
			$resp['error'] = $e->getMessage();

		} catch( \Exception $e ) {
			$this->a->error( $e );
			$resp['error'] = 'Error occurred. Charge can\'t be captured';
		}

		$this->response->setOutput( json_encode( $resp ) );
	}

	/**
	 * Refresh charge details for specific order on admin area
	 * @return void
	 */
	public function refresh() {
		$resp = [];

		try {
			if ( is_null( $this->a->requestParam( 'order_id' ) ) ) {
				throw new \Advertikon\Exception( $this->a->__( 'Order ID is missing' ) );
			}

			$resp['html'] = $this->order();
			$resp['success'] = 'ok';

		} catch( \Advertikon\Exception $e ) {
			$resp['error'] = $e->getMessage();

		} catch( \Stripe\Error\Base $e ) {
			$resp['error'] = $e->getMessage();

		} catch( Exception $e ) {
			$this->a->error( $e );
			$resp['error'] = 'Script error';
		}

		$this->a->json_response( $resp );
	}

	/**
	 * Refund payment from admin area action
	 * @return void
	 * @throws \Advertikon\Exception
	 */
	public function refund() {
		$resp = [];

		try {
			$order_id = $this->a->requestParam( 'order_id' );
			$amount   = $this->a->requestParam( 'amount' );
			$notify   = $this->a->requestParam( 'notify' );
			$override = $this->a->requestParam( 'override' );
			$reason   = $this->a->requestParam( 'reason' );

			if ( !$order_id ) {
				throw new \Advertikon\Exception( $this->a->__( 'Order ID is missing' ) );
			}

			$aOrder = Order::get( $order_id );
			$aOrder->refund( $amount, $reason, $override, $notify );
			$resp['success'] = $this->a->__( 'Success' );

		} catch( \Advertikon\Exception $e ) {
			$resp['error'] = $e->getMessage();

		} catch( \Stripe\Error\Base $e ) {
			$resp['error'] = $e->getMessage();

		} catch( Exception $e ) {
			$this->a->error( $e );
			$resp['error'] = 'Script error';
		}

		$this->response->setOutput( json_encode( $resp ) );
	}

	/**
	 * Buttons to manage recurring plan for customer's account page
	 * @return String
	 * @throws \Advertikon\Exception
	 */
	public function recurringButtons() {
		if ( !class_exists( 'Advertikon\Stripe\Recurring' ) ) {
			return '';
		}

        $this->document->addStyle( $this->a->u()->catalog_css( 'advertikon/advertikon.css' ) );

		$data  = [];
		$locale = [
		    'cancelSubscriptionText' => $this->a-> __( "Cancel subscription?" ),
            'order_recurring_id'     => $this->a->requestParam( 'order_recurring_id',
                $this->a->requestParam( 'recurring_id') )
        ];

		$data['requireJs']  = $this->a->requireJs(['stripe/recurring_buttons' => 'buttons' ], [], $locale );
		$data['can_cancel'] = true;

		$data['cancel_now_button']   = \Advertikon\Setting::get( 'cancel_subscription_now', $this->a ) ?
            (new Button())
                ->isDefault()
                ->url( $this->a->u()->url( 'recurring_delete_now' ) )
                ->title( $this->a->__( 'Cancel immediately' ) )
                ->icon('fa-times')
                ->id('adk-cancel-now')
            : '';

        $data['cancel_button'] = (new Button())
                ->isDefault()
                ->url( $this->a->u()->url( 'recurring_delete' ) )
                ->title( $this->a->__( 'Cancel at period end' ))
                ->icon('fa-calendar')
                ->id('adk-cancel-period');

        $data['refresh_button'] = (new Button())
            ->isDefault()
            ->url( $this->a->u()->url( 'recurring_refresh' ) )
            ->title( $this->a-> __( 'Refresh' ))
            ->icon('fa-refresh')
            ->id('adk-refresh');

		return $this->a->load->view(
			$this->a->get_template( $this->a->type . '/advertikon/stripe/recurring_button' ),
			$data
		);
	}

	/**
	 * Update recurring order
	 * @return void
	 */
	public function recurring_refresh() {
	    $ret = [];

		try {
			if ( !class_exists( 'Advertikon\Stripe\Recurring' ) ) {
				return;
			}

			$orderId = $this->a->requestParam( 'order_recurring_id' );

			if ( is_null( $orderId ) ) {
				throw new \Advertikon\Exception( 'Recurring order ID is missing' );
			}

			$aRecurring = \Advertikon\Stripe\Recurring::get( $orderId );

			if ( !$aRecurring->exists() ) {
				throw new \Advertikon\Exception( $this->a->__( 'Order is missing' ) );
			}

            $subscription = $aRecurring->fetch();

			if ( is_null( $subscription ) ) {
			    throw new Exception( 'Subscription is missing' );
            }

            $aRecurring->updateStatus( $subscription );
			$this->request->get['order_recurring_id'] = $orderId;

            if ( $this->a->is_admin() ) {
				$this->load->controller( 'sale/recurring/info' );

			} else {
				$this->load->controller( 'account/recurring/info' );
			}

			$ret['html'] = $this->response->getOutput();
			$ret['success'] = 'ok';

		} catch( \Advertikon\Exception $e ) {
			$ret['error'] = $e->getMessage();
			$this->a->error( $e );

		} catch( \Exception $e ) {
			$ret['error'] = 'Script error';
			$this->a->error( $e );
		}

		$this->a->json_response( $ret );
	}

	/**
	 * Cancel subscription at the next period end
	 * @return void
	 */
	public function recurring_delete() {
		if ( !class_exists( 'Advertikon\Stripe\Recurring' ) ) {
			return;
		}

		$ret = [];

		try {
			if ( !$this->a->has_permissions( \Advertikon\Advertikon::PERMISSION_MODIFY ) ) {
				throw new Exception( $this->a->__( 'You not have sufficient permissions' ) );
			}

			if ( !isset( $this->request->request['order_recurring_id'] ) ) {
				throw new \Advertikon\Exception( 'Recurring order ID is missing' );
			}

            $orderId = $this->a->requestParam( 'order_recurring_id' );

            if ( is_null( $orderId ) ) {
                throw new \Advertikon\Exception( 'Recurring order ID is missing' );
            }

            $aRecurring = \Advertikon\Stripe\Recurring::get( $orderId );

            if ( !$aRecurring->exists() ) {
                throw new \Advertikon\Exception( $this->a->__( 'Order is missing' ) );
            }

			$aRecurring->cancelAtPeriodEnd();
			$ret['success'] = $this->a->__('Subscription cancellation has been scheduled at the next period end' );

        } catch( \Advertikon\Exception $e ) {
            $ret['error'] = $e->getMessage();
            $this->a->error( $e );

        } catch( \Exception $e ) {
            $ret['error'] = 'Script error';
            $this->a->error( $e );
        }

        $this->a->json_response( $ret );
	}

	/**
	 * Cancel immediately recurring
	 * @return void
	 */
	public function recurring_delete_now() {
        if ( !class_exists( 'Advertikon\Stripe\Recurring' ) ) {
            return;
        }

        $ret = [];

        try {
            if ( !$this->a->has_permissions( \Advertikon\Advertikon::PERMISSION_MODIFY ) ) {
                throw new Exception( $this->a->__( 'You not have sufficient permissions' ) );
            }

            if ( !isset( $this->request->request['order_recurring_id'] ) ) {
                throw new \Advertikon\Exception( 'Recurring order ID is missing' );
            }

            $orderId = $this->a->requestParam( 'order_recurring_id' );

            if ( is_null( $orderId ) ) {
                throw new \Advertikon\Exception( 'Recurring order ID is missing' );
            }

            $aRecurring = \Advertikon\Stripe\Recurring::get( $orderId );

            if ( !$aRecurring->exists() ) {
                throw new \Advertikon\Exception( $this->a->__( 'Order is missing' ) );
            }

            $aRecurring->cancel();
            $ret['success'] = $this->a->__('Subscription has been cancelled' );

        } catch( \Advertikon\Exception $e ) {
            $ret['error'] = $e->getMessage();
            $this->a->error( $e );

        } catch( \Exception $e ) {
            $ret['error'] = 'Script error';
            $this->a->error( $e );
        }

        $this->a->json_response( $ret );
	}

	public function verify_apple() {
		$ret = [];

		try {
			$this->a->verify_apple();

		} catch ( \Advertikon\Exception $e ) {
			$ret['error'] = $this->a->__( 'Failed to automatically verify domain with Apple Pay' ) . ': ' . $e->getMessage();

		} catch ( \Stripe\Error\Base $e ) {
			$ret['error'] = $this->a->__( 'Failed to automatically verify domain with Apple Pay' ) . ': ' . $e->getMessage();

		} catch ( \Exception $e ) {
			$this->a->error( $e );
			$ret['error'] = $this->a->__( 'Failed to automatically verify domain with Apple Pay' ) .
				sprintf(
					' <a href="%s" targer="_blank">%s</a>',
					'https://stripe.com/docs/stripe-js/elements/payment-request-button#verifying-your-domain-with-apple-pay',
					$this->a->__( 'You need to do it manually' )
				);
		}

		$this->response->setOutput( json_encode( $ret ) );
	}

	public function register_webhook() {
		$ret = [];

		try {
			if ( !$this->a->has_permissions( \Advertikon\Advertikon::PERMISSION_MODIFY ) ) {
				throw new \Advertkon\Exception( $this->a->__( 'You not have sufficient permissions' ) );
			}

			$secret = $this->a->post( 'secret' );

			if ( !$secret ) {
				throw new \Advertkon\Exception( 'Secret key is missing' );
			}

			$sign = $this->model->register_webhook( $secret );

			if ( $sign ) {
				$ret['secret'] = $sign;
			}

		} catch( \Advertkon\Stripe\Exception $e ) {
			$this->a->error( $e );

		} catch ( \Exception $e ) {
			$this->a->error( $e );
			$ret['error'] = $e->getMessage();
		}

		$this->response->setOutput( json_encode( $ret ) );
	}
}

