<?php
class ModelExtensionModuleOrdercoupon extends Model {
     use OCM\Traits\Back\Model\Product;
     private $encoded_fields = array('general', 'discount', 'coupon', 'email_subject', 'email_body', 'sms_body');
     public function addDBTables() {
        $sql = "
           CREATE TABLE IF NOT EXISTS `".DB_PREFIX."ordercoupon_setting` (
            `general` text,
            `coupon` text,
            `discount` text,
            `email_subject` text,
            `email_body` mediumtext,
            `sms_body` text
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
        ";
        $query = $this->db->query($sql);

        $sql = "CREATE TABLE IF NOT EXISTS `".DB_PREFIX."ordercoupon_coupon` (
              `coupon_id` int(11) NOT NULL,
              `customer_id` int(11) NOT NULL,
              `customer_name` varchar(255) NOT NULL,
              `customer_email` varchar(255) NOT NULL,
              `date_added` datetime NOT NULL ,
              `order_id` int(11) NOT NULL,
               PRIMARY KEY (`coupon_id`)
             ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
        ";
        $query = $this->db->query($sql);
    }
    public function getTotalCoupons($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "ordercoupon_coupon r LEFT JOIN " . DB_PREFIX . "coupon c ON (r.coupon_id = c.coupon_id) WHERE 1";
        if (isset($data['filter_name']) && $data['filter_name'] != '') {
            $sql .= " AND r.customer_name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
        }
        if (isset($data['filter_email']) && $data['filter_email'] != '') {
            $sql .= " AND r.customer_email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
        }
        if (isset($data['filter_order_id']) && $data['filter_order_id'] != '') {
             $sql .= " AND r.order_id = '" . $data['filter_order_id'] . "'";
        }
        if (isset($data['filter_coupon'])  && $data['filter_coupon'] != '') {
             $sql .= " AND c.code = '" . $data['filter_coupon'] . "'";
        }
        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $sql .= " AND DATE(r.date_added) BETWEEN  DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }
        $query = $this->db->query($sql);
        return $query->row['total'];
    }
    public function getCoupons($data = array()) {
        $sql = "SELECT r.*, c.code, c.type, c.discount, c.status FROM " . DB_PREFIX . "ordercoupon_coupon r LEFT JOIN " . DB_PREFIX . "coupon c ON (r.coupon_id = c.coupon_id) WHERE 1";

        if (isset($data['filter_name']) && $data['filter_name'] != '') {
            $sql .= " AND r.customer_name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
        }
        if (isset($data['filter_email']) && $data['filter_email'] != '') {
            $sql .= " AND r.customer_email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
        }
        if (isset($data['filter_order_id']) && $data['filter_order_id'] != '') {
             $sql .= " AND r.order_id = '" . $data['filter_order_id'] . "'";
        }
        if (isset($data['filter_coupon']) && $data['filter_coupon'] != '') {
             $sql .= " AND c.code = '" . $data['filter_coupon'] . "'";
        }
        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $sql .= " AND DATE(r.date_added) BETWEEN  DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }
        $sort_data = array(
            'customer_name',
            'customer_email',
            'r.date_added'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];   
        } else {
            $sql .= " ORDER BY date_added";    
        }

        if (isset($data['order']) && ($data['order'] == 'ASC')) {
            $sql .= " ASC";
        } else {
            $sql .= " DESC";
        }
        
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }
            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }
    public function addCouponSetting($data) {
        $row_exist = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ordercoupon_setting` WHERE 1")->row;
        foreach($this->encoded_fields as $field){
            if(!isset($data[$field])){
                $data[$field] = '';
            }else{
                $data[$field] = json_encode($data[$field]);
            }
        }
       $sql_root = " discount = '" . $this->db->escape($data['discount']) . "', 
              coupon = '" . $this->db->escape($data['coupon']) . "', 
              general = '" . $this->db->escape($data['general']) . "', 
              sms_body = '" . $this->db->escape($data['sms_body']) . "',
              email_subject = '" . $this->db->escape($data['email_subject']) . "',
              email_body = '" . $this->db->escape($data['email_body']) . "'";

       $sql = $row_exist ?  "UPDATE `" . DB_PREFIX . "ordercoupon_setting` SET" : "INSERT INTO `" .DB_PREFIX . "ordercoupon_setting` SET";
       $sql .= $sql_root;
       $this->db->query($sql);
       return true;
    }
    public function getSetting() {
        $return = array();
        $setting = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ordercoupon_setting`")->row;
        foreach ($this->encoded_fields as $field) {
            $return[$field] = isset($setting[$field]) ? json_decode($setting[$field], true) : array();
        }
        return $return;
    }
    public function deleteCoupon($coupon_id) {
       $this->db->query("DELETE FROM " . DB_PREFIX . "ordercoupon_coupon WHERE coupon_id ='".(int)$coupon_id."'");
       /* delete coupon as well */
       $this->db->query("DELETE FROM " . DB_PREFIX . "coupon WHERE coupon_id = '" . (int)$coupon_id . "'");
       $this->db->query("DELETE FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");
       $this->db->query("DELETE FROM " . DB_PREFIX . "coupon_category WHERE coupon_id = '" . (int)$coupon_id . "'");
    }
}