<?php

use \vendor\isenselabs\autodetect\config as Config;

class ControllerExtensionModuleAutoDetect extends Controller {
    private $moduleModel;

	public function __construct($registry) {
        parent::__construct($registry);
        $this->load->model(Config::autodetect_path);
        $this->moduleModel = $this->{Config::autodetect_model_call};
    }

	public function detect() {
		$data = $res = $this->moduleModel->detect();
		$ad_config = $this->config->get('AutoDetect');
		if(!empty($ad_config["SearchEngines"]) && $ad_config["SearchEngines"]=="no") {
			if($this->isBot()) exit;
		}

		$data['reload'] = false;
		$data['syncmethod'] = $res['syncmethod'];
        $data['urlRedirect'] = ''; // General redirect, applied when $data['reload'] is true
        $page_route = !empty($this->session->data['autodetect_page_route']) ? $this->session->data['autodetect_page_route'] : array();

		if($res['languageto']){
			if(!isset($_COOKIE['languageChanged']) || $_COOKIE['languageChanged'] != $res['languageto']) {
				if( $this->session->data['language'] != $res['languageto']){
						 $this->session->data['language'] = $res['languageto'];
						 setcookie("languageChanged", $res['languageto'], time() + (86400 * 30)); // 30 days
						 $data['reload'] = true;

                        // Rebuild multi-language URL alias
                        if ($this->config->get('config_seo_url') && !empty($page_route['_route_'])) {
                            $segments = '';
                            if (!empty($page_route['path'])) {
                                $segments .= 'path=' . $page_route['path'];
                            }
                            if (!empty($page_route['product_id'])) {
                                $segments .= ($segments ? '&' : '') . 'product_id=' . $page_route['product_id'];
                            }
                            if (!empty($page_route['manufacturer_id'])) {
                                $segments .= ($segments ? '&' : '') . 'manufacturer_id=' . $page_route['manufacturer_id'];
                            }
                            if (!empty($page_route['information_id'])) {
                                $segments .= ($segments ? '&' : '') . 'information_id=' . $page_route['information_id'];
                            }

                            $data['urlRedirect'] = $this->url->link($page_route['route'], $segments);
                        }
				} else {
					setcookie("languageChanged", $res['languageto'], time() + (86400 * 30)); // 30 days
				}
			}
		}

		if($res['currencyto']){
			if(!isset($_COOKIE['currencyChanged']) || $_COOKIE['currencyChanged'] != $res['currencyto']) {
				if( $this->session->data['currency'] != $res['currencyto']){
					 $this->session->data['currency'] = $res['currencyto'];
					  setcookie("currencyChanged", $res['currencyto'], time() + (86400 * 30)); // 30 days
					  $data['reload'] = true;
				} else {
					 setcookie("currencyChanged", $res['currencyto'], time() + (86400 * 30)); // 30 days
				}
			}
		}

		if($res['redirectto']){
			$data['redirectto'] = $res['redirectto'];
			$data['manual_redirect'] = $res['manual_redirect'];
			$data['stripe_text'] = $res['stripe_text'];
			$data['button_text'] = $res['button_text'];
		}

		header('content-type: text/json');
		echo json_encode($data);exit;
	}

	public function test() {

		if (!isset($_SERVER['REMOTE_ADDR'])) {
			if (!isset($_GET['ip'])) {
				echo 'No way to detect the IP address. Your client does not identify itself and you have not set a custom IP parameter.';
				exit;
			}
		}

        $ip = "";
		if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                $valid_ip = filter_var($_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP);
                if($valid_ip) {
                	$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                }
        } else if(!empty($_SERVER['REMOTE_ADDR'])) {
                $valid_ip = filter_var($_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP);
        		if($valid_ip) {
        			$ip = $_SERVER['REMOTE_ADDR'];
        		}
        } else if (!empty($_SERVER["HTTP_CF_CONNECTING_IP"])) {
                $valid_ip = filter_var($_SERVER['HTTP_CF_CONNECTING_IP'], FILTER_VALIDATE_IP);
                if($valid_ip) {
                    $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
                }
        }

		if (!empty($_SERVER["HTTP_CF_CONNECTING_IP"])) {
			$ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
		}

		if (!empty($_GET['ip'])) {
			$ip = $_GET['ip'];
		}

        $json = file_get_contents('https://oc.ip2person.com/ip2country.php?ip='.$ip);
        $source = json_decode($json);
        $country = '';

        if (!empty($source->country)) {
            $country = $source->country;
        }

		echo '<p>IP address: '.$ip.'</p>';
		echo '<p>Country: <b>'.strtoupper($country).'</b></p>';
        if ($country) {
            $detect = $this->moduleModel->detect($ip);
            echo '<p>Language to: <b>'. $detect['languageto'] .'</b></p>';
            echo '<p>Currency to: <b>'. $detect['currencyto'] .'</b></p>';
            echo '<p>Redirect to: <b>'. $detect['redirectto'] .'</b></p>';
        }
	}

	public function isBot(){
		if (!isset($_SERVER['HTTP_USER_AGENT'])) {
			return false;
		}
		$bots = array(
			'Googlebot', 'Baiduspider', 'ia_archiver',
			'R6_FeedFetcher', 'NetcraftSurveyAgent', 'Sogou web spider',
			'bingbot', 'Yahoo! Slurp', 'facebookexternalhit', 'PrintfulBot',
			'msnbot', 'Twitterbot', 'UnwindFetchor',
			'urlresolver', 'Butterfly', 'TweetmemeBot' );
		foreach($bots as $b){
			if( stripos( $_SERVER['HTTP_USER_AGENT'], $b ) !== false ) return true;
		}
		return false;
	}

	/** Event handlers */

	public function viewCommonHeaderBefore(&$route, &$data, &$template) {
		$ad_config = $this->config->get('AutoDetect');

        if(!empty($ad_config['DetectMethod']) && $ad_config['DetectMethod'] == 'sync') {
            if (empty($this->session->data['autodetect_detectedlanguage']) || empty($this->session->data['autodetect_detectedredirectto']) || empty($this->session->data['autodetect_detectedcurrency'])) {

                $detect_res = $this->moduleModel->detect();
                $redirectToBePerformed = (!empty($detect_res['redirectto'])  && empty($this->session->data['autodetect_detectedredirectto']));

                if(!empty($detect_res['manual_redirect']) && !isset($_COOKIE['redirectto'])){
                    $data['text_stripe'] =  $detect_res['stripe_text'];
                    $data['button_stripe'] = $detect_res['button_text'];
                    $data['href_stripe'] = $detect_res['redirectto'];
                } else {
                	if ($redirectToBePerformed) {
                    	$request_uri = $_SERVER['REQUEST_URI'];
                    	$detect_res['redirectto'] = str_replace('{REQUEST_URI}',ltrim($request_uri,"/"),$detect_res['redirectto']);
                    	$detect_res['redirectto'] = str_replace('&amp;','&',$detect_res['redirectto']);
                    	$this->session->data['autodetect_detectedredirectto'] = $detect_res['redirectto'];

                        // Rebuild multi-language URL alias
                        $page_route = !empty($this->request->get) ? $this->request->get : array();
                        if ($this->config->get('config_seo_url') && !empty($page_route['_route_'])) {
                            $segments = '';
                            if (!empty($page_route['path'])) {
                                $segments .= 'path=' . $page_route['path'];
                            }
                            if (!empty($page_route['product_id'])) {
                                $segments .= ($segments ? '&' : '') . 'product_id=' . $page_route['product_id'];
                            }
                            if (!empty($page_route['manufacturer_id'])) {
                                $segments .= ($segments ? '&' : '') . 'manufacturer_id=' . $page_route['manufacturer_id'];
                            }
                            if (!empty($page_route['information_id'])) {
                                $segments .= ($segments ? '&' : '') . 'information_id=' . $page_route['information_id'];
                            }

                            $detect_res['redirectto'] = $this->url->link($page_route['route'], $segments);
                        }

                    	header('Location: '.$detect_res['redirectto']);
                    	exit;
            		}
                }
            }
        }

        $this->session->data['autodetect_page_route'] = $this->request->get;

        $data['scripts'][] = 'catalog/view/javascript/autodetect/autodetect.js';
	}

	public function viewCommonHeaderAfter(&$route, &$data, &$output) {
		if (!empty($data['href_stripe'])) {
			$insert = '<div style="display:block;" id="autodetect_stripe">
	          <a class="fa fa-times cancel"></a>
	          <span class="text">' . ((isset($data['text_stripe'])) ? $data['text_stripe'] : 'It looks like you\'re trying to visit our USA store, would you like to go to our UK store?') . '</span>
	          <button onclick="$.cookie(\'redirectto\', 1, { expires : 10 }); location.href=\'' . $data['href_stripe'] . '\';" class="confirm">' . (isset($data['button_stripe']) ? $data['button_stripe'] : 'Redirect me!') . '</button>
	        </div>';
	        $output = str_replace('<body>', '<body>'.$insert, $output);
		}
	}

	private static $alreadyReplacedCurrencyLib = false;
	private static $alreadyDetected = false;

	public function controllerAllBefore(&$route, &$data) {
		// inject modified currency lib
		if (!self::$alreadyReplacedCurrencyLib) {
			$originalCurrencyLib = $this->registry->get('currency');
			$originalClass = get_class($originalCurrencyLib);
			if (!class_exists('AutoDetect_SystemLibraryCartCurrencyAlias')) {
				class_alias($originalClass, 'AutoDetect_SystemLibraryCartCurrencyAlias');
			}
			$newCurrencyLib = new \vendor\isenselabs\autodetect\currencylib($this->registry, $originalCurrencyLib);
			$this->registry->set('currency', $newCurrencyLib);
			self::$alreadyReplacedCurrencyLib = true;
		}

		if (!self::$alreadyDetected) {
	        $ad_config = $this->config->get('AutoDetect');
	        if(!empty($ad_config['DetectMethod']) && $ad_config['DetectMethod'] == 'sync') {
	           if (empty($this->session->data['autodetect_detectedlanguage']) || empty($this->session->data['autodetect_detectedredirectto']) || empty($this->session->data['autodetect_detectedcurrency'])) {
	                $detect_res = $this->moduleModel->detect();
	                $languageToBeChanged = (!empty($detect_res['languageto']) && empty($this->session->data['autodetect_detectedlanguage']));
	                $currencyToBeChanged = (!empty($detect_res['currencyto']) && empty($this->session->data['autodetect_detectedcurrency']));

	                if ($languageToBeChanged) {
	                    $this->session->data['autodetect_detectedlanguage'] = $detect_res['languageto'];
	                    $this->session->data['language'] = $detect_res['languageto'];
	                }

	                if ($currencyToBeChanged) {
	                    $this->session->data['autodetect_detectedcurrency'] = $detect_res['currencyto'];
	                    $this->session->data['currency'] = $detect_res['currencyto'];
	                }
	            }
	        }
	        self::$alreadyDetected = true;
	    }
	}

}

?>
