<?php
class ModelExtensionModuleOrdercoupon extends Model {
    use OCM\Traits\Front\Coupon;
    use OCM\Traits\Front\Curl;
    use OCM\Traits\Front\Equation;
    private $mtype;
    private $settings;
    public function __construct($registry) {
        parent::__construct($registry);
        $this->registry = $registry;
        $this->ocm = ($ocm = $this->registry->get('ocm_front')) ? $ocm : new OCM\Front($this->registry);
        $this->mtype = 'module';
        $this->settings = $this->getSetting();
    }
    public function onOrderHistory($order_id, $order_status_id) {
        $this->processCoupon($order_id, $order_status_id);
    }
    public function processCoupon($order_id, $order_status_id) {
        if (!in_array($order_status_id, $this->settings['general']['complete_status'])) {
            return false;
        }
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if (!$order_info) {
            return false;
        }
        $order_coupon =  $this->db->query("SELECT * FROM `" . DB_PREFIX . "ordercoupon_coupon` WHERE order_id = '".(int)$order_id."'")->row;
        if ($order_coupon) {
            return false;
        }
        
        $_coupon = $this->sanitizeCoupon($this->settings['coupon']);
        $range = $this->_getTargetFromRange($this->settings['discount'], $order_info['total']);
        if (!$range && !$_coupon['xcoupon_id']) {
            return false;
        }
        if ($range && !$_coupon['xcoupon_id']) {
            if (preg_match('/{\w+}/', $range['value'])) {
                $sub_total = 0;
                if (strpos($range['value'], '{subTotal}') !== false) {
                    $subtotal_row = $this->db->query("SELECT value FROM `" . DB_PREFIX . "order_total` WHERE order_id = '" . (int)$order_id . "'")->row;
                    if ($subtotal_row) {
                        $sub_total = $subtotal_row['value'];
                    }
                }
                $eq_placholder = array('{subTotal}', '{total}');
                $eq_placeholder = array($sub_total, $order_info['total']);
                $percent_of = $sub_total ? $sub_total : $order_info['total'];
                $range['value'] = $this->getEquationValue($eq_placholder, $eq_placeholder, $percent_of, $range['value']);
            }
            $couponValue = $range['percent'] ? $range['value'] . '%' : $this->currency->format($range['value'], $this->config->get('config_currency'));
            $_coupon['discount'] = $range['value'];
            $_coupon['type'] = $range['percent'] ? 'P' : 'F';
        } else {
            $couponValue = '';
        }
        /* Coupon for recipient*/
        $code = $this->getCouponCode();
        $_coupon['code'] = $code;
        $coupon_id = $this->insertCoupon($_coupon);

        $customer_name = $order_info['firstname'] . ' ' . $order_info['lastname'];
        $order_coupon_data = array();
        $order_coupon_data['coupon_id'] = $coupon_id;
        $order_coupon_data['order_id'] = $order_id;
        $order_coupon_data['customer_id'] = $order_info['customer_id'];
        $order_coupon_data['customer_name'] = $customer_name;
        $order_coupon_data['customer_email'] = $order_info['email'];
        $this->addOrderCoupon($order_coupon_data);

        $placeholders = array('{firstName}', '{lastName}', '{fullName}', '{email}', '{orderId}', '{storeName}', '{storeUrl}', '{couponCode}', '{couponValue}');
        $replacers = array($order_info['firstname'], $order_info['lastname'], $customer_name, $order_info['email'], $order_id, $this->config->get('config_meta_title'), $this->ocm->common->getSiteURL(), $code, $couponValue);

        $this->processEmail($placeholders, $replacers, $order_info['email']);
        // send sms
        if ($this->settings['general']['sms'] && $this->settings['sms_body']) {
            $phone = $order_info['telephone'];
            $phone_row = $this->db->query("SELECT telephone FROM `" . DB_PREFIX . "customer` WHERE customer_id='" . (int)$order_info['customer_id'] . "'")->row;
            if ($phone_row && $phone_row['telephone']) {
                $phone = $phone_row['telephone'];
            }
            $phone = preg_replace('/[^\d]+/', '', $phone);
            /* DON'T NEED
            if (substr($phone, 0, 1) !== '+') {
                $country_id = $order_info['payment_country_id'];
                if (!$country_id) {
                    $country_id = (int)$this->config->get('config_country_id');
                }
                $country_row = $this->db->query("SELECT iso_code_2 FROM `" . DB_PREFIX . "country` WHERE country_id='" . (int)$country_id . "'")->row;
                if ($country_row) {
                    $phone = $this->country2phone($country_row['iso_code_2']) . $phone;
                }
            } */
            if ($phone) {
                $placeholders[] = '{mobile}';
                $replacers[] = $phone;
                $placeholders[] = '{message}';
                $replacers[] = str_replace($placeholders, $replacers, $this->settings['sms_body']);
                $this->processSms($placeholders, $replacers, $this->settings['general']['curl']);
            }
        }
    }
    public function processEmail($placeholders, $replacers, $to) {
        if (!$this->settings['email_subject'] || !$this->settings['email_body']) {
            return;
        }
        $subject = str_replace($placeholders, $replacers, $this->settings['email_subject']);
        $body = str_replace($placeholders, $replacers, $this->settings['email_body']);
        $data = array();
        $data['to'] = $to;
        $data['subject'] = $subject;
        $data['message'] = $body;
        $this->ocm->sendMail($data);
    }
    private function processSms($placeholders, $replacers, $curl) {
        $request = $this->sanitizeCurl($curl, $placeholders, $replacers);
        $result = false;
        if ($request['url']) {
            $param = array();
            $param['encoding'] = $request['encoding'];
            $result = $this->ocm->common->curlReq($request['url'], $request['method'], $request['body'], $request['header'], $param);
            $json = @json_decode($result, true);
            if(json_last_error() === JSON_ERROR_NONE) {
                $result = $json;
            }
            if (!empty($curl['debug']) && $curl['debug']) {
                $this->logCurl($request, $result, 'Order Coupon');
            }
        }
        return $result;
    }
    public function doSmsTest($phone, $message) {
        if (VERSION < '2.1.0.1') {
            $this->load->library('user');
        }
        $user = VERSION > '2.1.0.1' ? new Cart\User($this->registry) : new User($this->registry);
        if (!(boolean)$user->isLogged()) {
            return 'You are not allow to call this request';
        }
        $phone = preg_replace('/[^\d]+/', '', $phone);
        if (!$phone) {
            return 'Invalid phone number';
        }
        /* DON'T NEED
        if (substr($phone, 0, 1) !== '+') {
            $country_id = (int)$this->config->get('config_country_id');
            $country_row = $this->db->query("SELECT iso_code_2 FROM `" . DB_PREFIX . "country` WHERE country_id='" . (int)$country_id . "'")->row;
            if ($country_row) {
                $phone = $this->country2phone($country_row['iso_code_2']) . $phone;
            }
        } */
        $placeholders = array('{mobile}', '{message}');
        $replacers = array($phone, $message);
        return $this->processSms($placeholders, $replacers, $this->settings['general']['curl']);
    }
    public function addOrderCoupon($data) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "ordercoupon_coupon SET coupon_id = '" . (int)$data['coupon_id'] . "', customer_id = '" . (int)$data['customer_id'] . "', customer_name = '" . $this->db->escape($data['customer_name']) . "', customer_email = '" . $this->db->escape($data['customer_email']) . "', order_id = '" . (int)$data['order_id'] . "', date_added = NOW()");
    }
    public function getSetting() {
        if (!$this->ocm->getConfig('ordercoupon_status', $this->mtype)) {
            return false;
        }
        $fields = array('general', 'coupon', 'discount', 'email_subject', 'email_body', 'sms_body');
        $config_row = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ordercoupon_setting`")->row;
        $config = array();
        foreach ($fields as $field) {
            $config[$field] = $config_row && isset($config_row[$field]) ? json_decode($config_row[$field], true) : array();
        }
        if (!isset($config['general']['sms'])) {
            $config['general']['sms'] = false;
        }
        if (empty($config['general']['complete_status'])) {
            $config['general']['complete_status'] = $this->config->get('config_complete_status');
        }

        $curl = isset($config['general']['curl']) ? $config['general']['curl'] : array();
        $config['general']['curl'] = $curl;

        $setting = array();
        $setting['status'] = (bool)$this->ocm->getConfig('ordercoupon_status', $this->mtype);
        $setting['general'] = $config['general'];
        $setting['coupon'] = $config['coupon'];
        $setting['discount'] = $this->_findRawRate($config['discount']);
        $setting['email_subject'] = $config['email_subject'];
        $setting['email_body'] = $config['email_body'];
        $setting['sms_body'] = $config['sms_body'];
        return $this->getSettingByLang($setting);
    }
    private function getSettingByLang($setting) {
        $language_id = (int)$this->config->get('config_language_id');
        $lang_fields = array('email_subject', 'email_body', 'sms_body');
        foreach ($lang_fields as $field) {
            $setting[$field] = isset($setting[$field][$language_id]) ? $this->ocm->html_decode($setting[$field][$language_id]) : '';
        }
        return $setting;
    }
    private function _findRawRate($ranges) {
        $return = array();
        if (!is_array($ranges)) return $return;
        foreach($ranges as $range) {
            $start = (float)$range['start'];
            $end = (float)$range['end'];
            $cost = trim(trim($range['cost']), '-');
            if (preg_match('/{\w+}/', $cost)) {
                $percent = false;
                $value = $this->ocm->html_decode($cost);
            } else if (substr($cost, -1) == '%') {
                $cost = rtrim($cost,'%');
                $percent = true;
                $value = (float)$cost;
            } else {
                $percent = false;
                $value = (float)$cost;
            }
            if ($start && !$end) {
                $end = PHP_INT_MAX;
            }
            $return[] = array('start' => $start, 'end' => $end, 'percent' => $percent, 'value' => $value);
        }
        return $return;
    }
    private function _getTargetFromRange($ranges, $target) {
        $target_range = array();
        foreach($ranges as $range) {
            if ($range['start'] <= $target && $target <= $range['end']) {
                $target_range = $range;
                 break;
            }
        }
        return $target_range;
    }
    private function getEquationValue($placholder, $replacer, $percent_of, $equation) {
        $equation = str_replace($placholder, $replacer, $equation);
        /* replace percentage value finally so it won't replace mod operator */
        $equation = preg_replace('/(\d+)%/', '$1*' . ($percent_of/100), $equation);
        /* Removing unwanted placeholder */
        if (strpos($equation, '{') !== false) {
            $equation = preg_replace('/{.*?}/', 0, $equation);
        }
        return (float)$this->calculate_string($equation);
    }
}