define( "stripe/account", [ "alert" ], function( Alert ) {
    function Account() {
        var locale;
        var $tab = $( "#tab-general-api" );
        var self = this;
        var currencies = [];

        $tab.delegate( ".delete-account", "click", function(){self.delete(this)} );
        $tab.delegate( ".account-currency", "change", function() { self.changeCurrency(this)} );
        $( "#add-account" ).on( "click", function () { self.add(this); } );

        this.setLocale = function ( locale ) {
            this.locale = locale;
            Alert.setLocale( locale )
        };

        /**
         * Checks existing accounts for currency
         * Block/unblock add accounts button
         * Return true if currencies for different accounts don't repeat, false otherwise.
         * @param {jQuery} input Element
         * @returns {boolean} If currency is unique
         */
        function checkCurrency ( input ) {
            var
                count = 0,
                currencySet = [];

            // Block add account button if account count equals store currencies
            if( $( ".account-currency" ).length === self.locale.currency.length ) {
                $( "#add-account" ).attr( "disabled", "disabled" );

            } else {
                $( "#add-account" ).removeAttr( "disabled" );
            }

            if( typeof input !== "undefined" ) {
                $( ".account-currency" ).not( input ).each( function ( index, item ) {
                    currencySet.push( $( item ).val() );
                } );

                return !currencySet.some( function(v) { return v === input.val(); } );
            }
        }

        /**
         * Set spare currency code to newly created account field
         * @returns {void}
         */
        function setCurrency () {
            var currencyInputs = $( ".account-currency" );
            var availableCurrencies = [];

            // Existing currencies" codes
            currencyInputs.eq( 0 ).find( "option" ).each( function () {
                availableCurrencies.push( $( this ).attr( "value" ) );
            } );

            currencyInputs.each( function( index, item ) {
               var val  = $( item ).val();
               var newVal;

               if ( availableCurrencies.some( function(v) { return v === val } ) ) {
                   availableCurrencies = availableCurrencies.filter( function(v) { return v !== val; } );

               } else if ( availableCurrencies.length > 0 ) {
                   newVal = availableCurrencies[0];
                   availableCurrencies = availableCurrencies.filter( function(v) { return v !== newVal } );
                   $(item).val( newVal );
                   $(item).attr( "data-value", newVal );
               }
            } );
        }

        /**
         * Adds Stripe account
         * @returns {void}
         */
        this.add = function ( button ) {
            var $templ = $( this.locale.accountDetailsTemplate.replace( /{template_name}/g, Math.round( Math.random() * 1000000000 ) ) );

            $templ.find( "[data-name]" ).each( function ( index, item ) {
                $(item).attr( "name", $(item).attr( "data-name" ) );
            } );

            $( button ).closest( ".tab-pane" ).find( ".account-wrapper:last-child" ).after( $templ );
            checkCurrency();
            setCurrency();
        };

        /**
         * Change currency callback
         * @returns {void}
         */
        this.changeCurrency = function (select) {
            var $select = $( select );

            if( !checkCurrency( $select ) ) {
                $select.val( $select.attr('data-value') );
                Alert.alert( this.locale.errorAcountSameCurrency );

            } else {
                $select.attr("data-value", $select.val() );
            }
        };

        /**
         * Deletes Stripe account
         * @returns {void}
         */
        this.delete = function ( button ) {
            $( button ).parents( ".account-wrapper" ).remove();
            checkCurrency();
        };
    }

    return new Account();
} );