define( "stripe/account_cards", ["alert", "button"], function( Alert, Button) {
    function AccountCards() {
        var locale;
        var $deleteButton = $( ".adk-delete" );

        this.run = function( loc ) {
            locale = loc;
            Alert.setLocale( loc );
        };

        $deleteButton.on( "click", function() {
            var self = this;

            Alert.confirm( locale.deleteCard ).yes( function() {
                delete_card.call( self ) ;
            } );
        } );

        $( ".adk-default" ).on( "click", function() {
            default_card.call( this );
        } );

        function delete_card( card_id ) {
            var $button  = $( this );

            Button.url( $button, { card_id: $button.closest( "tr" ).attr("data-id" ) } )
                .done( function ( resp ) {
                    // If default card was deleted
                    if( resp.default_source ) {
                        $( ".adk-default" ).removeAttr( "disabled" ).removeClass( "btn-success" ).addClass( "btn-default" );

                        $button.closest( "table" ).find( "tr[data-id=" + resp.default_source + "] .adk-default" )
                            .attr( "disabled", "disabled" )
                            .removeClass( "btn-default" )
                            .addClass( "btn-success" );
                    }

                    $button.closest( "tr" ).remove();
                } );
        }

        function default_card() {
            var $button  = $( this );

            Button.url( $button , { card_id: $button.closest( "tr" ).attr("data-id" ) } )
                .done( function () {
                    $( ".adk-default" ).removeAttr( "disabled" ).removeClass( "btn-success" ).addClass( "btn-default" );
                    $button.attr( "disabled", "disabled" ).removeClass( "btn-default" ).addClass( "btn-success" );
                } );
        }
    }

    return new AccountCards();
} );