define( "stripe/admin",
    [ "adk", "stripe/account", "ui_init", "slider", "iris", "translator", "select2", "form", "notification", "animate_css", "support" ],
    function ( ADK, Account, UI, Slider, Iris, Translator, Select2, Form, Notificaiton ) {

    function Admin() {
        this.locale = {};

        this.setLocale = function ( locale ) {
            this.locale = locale;
        };

        // Entry point
        this.run = function( locale ) {
            this.setLocale( locale );
            ADK.locale = locale;
            Account.setLocale( locale );
            UI.init();
            Slider.init();
            Iris.init();
            Translator.init();
            Select2.init();
            Form.init( document.getElementById( 'form-config' ) );

           this.initMainTabs();

           $(document).on("change", ".secret-secret, .secret-public", checkSigning );
           verifyApple();
        };

        this.initMainTabs = function() {
            // Rewrite default behavior so tab can be wrapped into elements
            $( "[data-toggle=tab-top]" ).each( function e() {
                this.onclick = function () {
                    $( "[data-toggle=tab-top]" ).parent().removeClass( "active" );

                    $( this ).parent().addClass( "active" );

                    $( ".top-pane" ).removeClass( "active" );

                    $( ".top-pane" + $( this ).attr( "href" ) ).addClass( "active" );

                    return false;
                };
            } );

            $( "[data-toggle=tab-top].active" ).click();
        };

        function verifyApple() {
            if ( !ADK.locale.isAppleVerified ) {
                $.getJSON( ADK.locale.appleVerifyUrl )

                    .done( function( resp ) {
                        if ( resp.success ) {
                            showSuccess( resp.success );
                        }

                        if ( resp.error ) {
                            showError( resp.error );
                        }
                    } );
            }
        }

        function checkSigning() {
            var
                secret, pUblic, signing, prefix;

            prefix = $( this ).hasClass( "secret-live" ) ? "-live" : "-test";

            if ( $( this ).hasClass( "secret-secret" ) ) {
                secret  = $( this );
                pUblic  = $( ".secret" + prefix + ".secret-public" );
                signing = $( ".secret" + prefix + ".secret-signing" );

            } else {
                pUblic  = $( this );
                secret  = $( ".secret" + prefix + ".secret-secret" );
                signing = $( ".secret" + prefix + ".secret-signing" );
            }

            if ( !checkKeys( "-test" === prefix, secret.val(), pUblic.val() ) ) {
                return;
            }

            if ( secret.val() && pUblic.val() ) {
                checkWebhook( secret.val(), pUblic.val(), signing );
            }
        }

        function checkKeys( isTest, secretKey, publicKey ) {
            if ( isTest ) {
                if ( publicKey && publicKey.indexOf( "_test_" ) === -1 || secretKey && secretKey.indexOf( "_test_" ) === -1 ) {
                    Notificaiton.alert( "Test key required" );
                    return false;
                }

            } else {
                if ( publicKey && publicKey.indexOf( "_live_" ) === -1 || secretKey && secretKey.indexOf( "_live_" ) === -1 ) {
                    Notificaiton.alert( "Live key required" );
                    return false;
                }
            }

            if ( secretKey && secretKey.indexOf( "sk_" ) !== 0 ) {
                Notificaiton.alert( "Secret key required" );
                return false;
            }

            if ( publicKey && publicKey.indexOf( "pk_" ) !== 0 ) {
                Notificaiton.alert( "Public key required" );
                return false;
            }

            return true;
        }

        function checkWebhook( secretKey, publicKey, signingField ) {
            var
                data = {
                    secret: secretKey,
                    public: publicKey,
                };

            $.post( ADK.locale.registerWebhookUrl, data, null, "json" )
                .done( function( resp ) {
                    if ( resp.error ) {
                       showError( resp.error );

                    } else if ( resp.secret ) {
                        signingField.val( resp.secret );
                    }
                } );
        }

        function scanWebhooks() {
            $( ".account-wrapper" ).each( function accounts() {
                var
                    testPublic = $( this ).find( ".secret-test.secret-public" ),
                    testSecret = $( this ).find( ".secret-test.secret-secret" ),
                    testSigning = $( this ).find( ".secret-test.secret-signing" ),
                    livePublic = $( this ).find( ".secret-live.secret-public" ),
                    liveSecret = $( this ).find( ".secret-live.secret-secret" ),
                    liveSigning = $( this ).find( ".secret-live.secret-signing" );

                if ( liveSecret.val() && livePublic.val() ) {
                    checkWebhook( liveSecret.val(), livePublic.val(), liveSigning );
                }

                if ( testSecret.val() && testPublic.val() ) {
                    checkWebhook( testSecret.val(), testPublic.val(), testSigning );
                }
            } );
        }

        function showSuccess( text ) {
            var target = $(".error-message-template.template");
            var element = target.clone();
            element.insertAfter( target );
            element.removeClass('template');
            element.css('display', 'block' );
            element.find('i').html(text);
        }

        function showError( text ) {
            var target = $(".error-message-template.template");
            var element = target.clone();
            element.insertAfter( target );
            element.removeClass('template');
            element.css('display', 'block' );
            element.find('i').html(text);
        }
    }

    return new Admin();
});