define( "stripe/admin_order", ["notification", "button", "adk" ], function(Notificaiton, Button, ADK ) {

    function Order() {
        var locale;
        var token = '';

        this.run = function( loc ) {
            locale = loc;
            ADK.locale = loc;
        };

        $(document).on("click", "#adk-capture-button", function() {
            var val      = $( "#adk-capture" ).val();
            var $button  = $( this );
            var notify   = $( "#adk-notify-capture" ).is( ":checked" ) ? 1 : 0;
            var override = $( "#adk-overide-capture" ).is( ":checked" ) ? 1 : 0;

            if( val === '' ) {
                Notificaiton.alert( locale.amountMessage );
                return;

            } else {
                if( !confirm( $button.attr( 'data-confirm' ) + " " + val + " " + $button.attr( 'data-currency' ) ) ) {
                    return;
                }
            }

            Button.url( $button, {
                order_id: $button.attr('data-order-id' ),
                amount  : val,
            } )
                .done( function ( resp ) {
                    addHistory(
                        $button.attr('data-status'),
                        $button.attr('data-history') + ' ' + val + ' ' + $button.attr('data-currency' ),
                        notify,
                        override
                    ).always( function(){ $("#adk-refresh").trigger("click"); } );
                } )
        } );

        function addHistory( orderStatus , comment , notify , override ) {
            var def = $.Deferred();

            if ( typeof token === "undefined" ) {
                token = '';
            }

            jQuery.ajax( {
                url: locale.history_url + '&token=' + token + '&api_token=' + locale.api_token,
                type: 'POST',
                data: {
                    order_id       : locale.order_id,
                    order_status_id: orderStatus,
                    comment        : comment,
                    notify         : notify,
                    override       : override
                }
            } )

                .fail( function(){
                    def.reject();
                } )

                .done( function( resp ){
                    $( "#history" ).load( locale.oc_history_url );
                    def.resolve( resp );
                } );

            return def;
        }

        // Capture amount input field
        $(document).on("change", "#adk-capture", function() {
            var max = parseFloat( locale.amount ),
                val = this.value.replace( /[^0-9\\.]/g , '' );

            this.value = max < val ? max : val;
        } );

        $(document).on("click", "#adk-refund-button", function() {
            var val =  $( "#adk-refund" ).val();
            var max = parseFloat(locale.operatable_amount );
            var $button = $( this );
            var notify   = $( "#adk-notify-refund" ).is( ":checked" ) ? 1 : 0;
            var override = $( "#adk-overide-refund" ).is( ":checked" ) ? 1 : 0;
            var $reasonSelect = $("#refund-reason");

            if( val === '' ) {
                Notificaiton.alert( locale.minAmountAlert );
                return;

            } else {
                if( !confirm( $button.attr( 'data-confirm' ) + " " + val + " " + $button.attr( 'data-currency' ) ) ) {
                    return;
                }
            }

            Button.url( $button, {
                order_id: $button.attr('data-order-id' ),
                amount  : val,
                reason:   $reasonSelect.val()
            } )
                .done( function ( resp ) {
                    var stat = max == val ? $button.attr('data-status') : locale.current_status;

                    addHistory(
                        stat,
                        $button.attr('data-history') + ' ' + val + ' ' + $button.attr('data-currency' ),
                        notify,
                        override
                    ).always( function(){ $("#adk-refresh").trigger("click"); } );
                } )
        } );

        // Refund amount input field
        $(document).on("change", "#adk-refund", function() {
            var max = parseFloat( locale.operatable_amount );
            var val = this.value.replace( /[^0-9\\.]/g , '' );
            this.value = max < val ? max : val;
        } );

        $(document).on( "click", "#adk-refresh", function() {
            var $button = $( this );

            Button.url( $button, { order_id: locale.order_id } )
                .always( function( resp ) {
                    if ( resp.error ) return;

                    if ( resp.html ) {
                        $( "#tab-advertikon_stripe" ).empty().append( $( resp.html ) );
                    }
                } );
        } );

        // Retrieve order current status ID
        $( "#button-history" ).on( "click" , function(){
            window.setTimeout( function() { $("#adk-refresh").trigger("click"); } , 2000 );
        } );
    }

    return new Order();
} );