define( "stripe/button", [], function () {
    function Button( element ) {
        var $button = $( element );
        var $journalButton = $( "#journal-checkout-confirm-button" );
        var onSubmit;

        this.off = function () {
            try {
                $button.button( "reset" );
            } catch ( e ) {
                console.log( e );
            }

            // Journal fix
            if ( $journalButton.length ) {
                $journalButton.button( "reset" ).removeClass( "checkout-loading" );
            }

            // Journal 2.9 fix
            if ( "triggerLoadingOff" in window ) {
                if( typeof ajax_calls !== "undefined" ) {
                    ajax_calls = 1;
                }

                triggerLoadingOff();
            }
        };

        this.on = function () {
            try{
                $button.button( "loading" );
            } catch ( e ) {
                console.log( e );
            }

            // Journal fix
            if ( $journalButton.length ) {
                $journalButton.button( "loading" );
            }

            // Journal 2.9 fix
            if ( "triggerLoadingOn" in window ) {
                triggerLoadingOn();
            }
        };

        this.onSubmit = function ( cb ) {
            onSubmit = cb;
        };

        this.enable = function () {
            $button.removeAttr('disabled');
        };

        this.disable = function() {
            $button.attr( "disabled", "disabled" );
        };

        this.hide = function () {
            $button.hide();
        };

        this.show = function() {
            $button.show();
        };

        function submit(evt) {
            evt.preventDefault();

            if ( onSubmit ) onSubmit();
        }

        +function init() {
            $button.on( "click", submit )
        }();
    }

    return {
        init: function( button ) {
            return new Button( button );
        }
    }
} );