define( "stripe/card-preview", ["adk"], function(ADK) {
    function Preview() {
        var cardPreviewTimeout;

        function show() {
            if ( !$( "#adk-card-preview" ).length ) {
                $( "body" ).append(
                    "<div id='adk-card-preview'>" +
                    "<div class='adk-card-preview-front'>" +
                    "<div id='adk-card-preview-number' class='adk-card-highlight'></div>" +
                    "<div id='adk-card-preview-expiry' class='adk-card-highlight'></div>" +
                    "</div>" +
                    "<div class='adk-card-preview-back'>" +
                    "<div id='adk-card-preview-cvv' class='adk-card-highlight'></div>" +
                    "</div>" +
                    "</div>"
                );

                $( ".adk-card-preview-front" ).css( "background-image", "url(" + ADK.locale.cardPreviewFront + ")" );
                $( ".adk-card-preview-back" ).css( "background-image", "url(" + ADK.locale.cardPreviewBack + ")" );

                $( "#adk-card-preview" ).fadeIn();
            }
        }

        function hide() {
            $( "#adk-card-preview" ).remove();
        }

        function hideDelay() {
            cardPreviewTimeout = setTimeout( hide, 10000 );
        }

        this.number = function ( doShow ) {
            if ( !doShowCardPreview() ) {
                return;
            }

            if ( doShow ) {
                show();
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(10deg)" );
                $( "#adk-card-preview-number" ).addClass( "border-flash" );
                clearTimeout( cardPreviewTimeout );

            } else {
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(0deg)" );
                $( "#adk-card-preview-number" ).removeClass( "border-flash" );
                hideDelay();
            }
        };

        this.expiry = function (doShow) {
            if ( !doShowCardPreview() ) {
                return;
            }

            if ( doShow ) {
                show();
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(-10deg)" );
                $( "#adk-card-preview-expiry" ).addClass( "border-flash" );
                clearTimeout( cardPreviewTimeout );

            } else {
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(0deg)" );
                $( "#adk-card-preview-expiry" ).removeClass( "border-flash" );
                hideDelay();
            }
        };

        this.cvv = function (doShow) {
            if ( !doShowCardPreview() ) {
                return;
            }

            if ( doShow ) {
                show();
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(180deg)" );
                $( "#adk-card-preview-cvv" ).addClass( "border-flash" );
                clearTimeout( cardPreviewTimeout );

            } else {
                $( "#adk-card-preview" ).css( "transform", "perspective(500px) rotateY(0deg)" );
                $( "#adk-card-preview-cvv" ).removeClass( "border-flash" );
                hideDelay();
            }
        };

        function doShowCardPreview() {
            return ADK.locale.showCardPreview === '1';
        }
    }

    return new Preview();
} );