define( "stripe/form", ["stripe/method-slider", "stripe/payment", "stripe/button", "stripe/message", "adk", "animate_css" ],
    function( Slider, Payment, Button, Message, ADK ) {

    function Form( element, loc ) {
        var $form = $( element );
        var slider;
        var locale = loc;
        var $wrapper;
        var $bodies;
        var $button;
        var $popupButton;
        var message;
        var button;
        var $overlay;

        function selectPaymentMethod ( code ) {
            $bodies.removeClass( 'active' );
            $wrapper.find( "." + code ).addClass( 'active' );
            Payment.onOptionSelect( code );
        }

        function setHeight() {
            var height = 0;
            var activeItem = $wrapper.find(".active");
            $wrapper.css('height', 'auto');

            $bodies.each( function(index, item ) {
                var $item = $( item );
                $item.addClass( 'active' );
                height = Math.max( height, $(item).outerHeight());
                $item.removeClass('active' );
            } );

           $wrapper.height( height );
           activeItem.addClass("active" );
        }

        function activateSomething() {
            slider.activateSomething();
        }

        function showCardSecretField() {
            var $wrapper = $( "#adk-secret-wrapper" );

            if ( $("#remember-me").is(":checked") && !ADK.isEmpty( locale.showSavedCardSecret ) ) {
                $wrapper.css('opacity', 1);
            } else {
                $wrapper.css( 'opacity', 0 );
            }
        }

        function setUpForm() {
            $( "body > .adk-stripe-overlay" ).remove();
            setUp();

            if ( $popupButton.length > 0 ) {
                $overlay = $button.closest(".adk-stripe-overlay" );
                $("body").append($overlay);
                $overlay.on("click", hidePopUp );
            }
        }

        function showPopUp() {
            $overlay.css( 'top', window.scrollY );
            $("body").addClass( "adk-popupped" );
            setHeight();
            $( ".adk-overlay-inner" ).animateCss( ADK.locale.formAnimationIn );
        }

        function hidePopUp( evt ) {
            if( evt && evt.target !== this ) {
                return;
            }

            // do not hide popup when payment is started
            if ( Payment.isPaymentProcessing() ) {
                return;
            }

            $( ".adk-overlay-inner" ).animateCss( ADK.locale.formAnimationOut );
            Payment.onPopUpHide();

            setTimeout( function () {
                $("body").removeClass( "adk-popupped" );
            }, 1000 );
        }

        function setUp() {
            $wrapper = $( ".adk-methods-wrapper" );
            $bodies = $wrapper.children();
            $button = $(".adk-confirm" );
            $popupButton = $(".adk-show-popup" );
            message = Message.init( $(".adk-overflower" ) );
            button = Button.init( $button.eq(0)[0] );
        }

        +function init( self ) {
            setUpForm();
            slider = Slider.init( $form.find( ".adk-methods-header-slider" )[0], locale );
            slider.onSelect( selectPaymentMethod );
            Payment.setLocale( locale, button, message );
            setHeight();
            activateSomething();
            $("#remember-me").on( "change", showCardSecretField );
            $(document).on("adk-request-layout", setHeight );
            $popupButton.on("click", showPopUp );
        }( this );
    }

    return {
        init: function( element, locale ) {
            element.adk_form = new Form( element, locale );
        }
    };

} );