define( "stripe/message", [], function() {
    function Message( element ) {
        var $element = $( element );
        var $messageBody;
        var $messageText;
        var $close;
        var queue = [];
        var isProcessing = false;
        var animationDuration = 500;
        var self = this;

        this.success = function( message ) {
            queue.push( new QueueItem( message, 'success' ) );
            runQueue();
        };

        this.error = function(message) {
            queue.push( new QueueItem( message, 'error' ) );
            runQueue();
        };

        this.progress = function(message) {
            queue.push( new QueueItem( message, 'progress' ) );
            runQueue();
        };

        this.hide = function() {
            queue.shift().hide();
        };

        function addItself(self) {
            var $wrapper = $(
                // '<div class="adk-message-container">' +
                '<div id="adk-message-wrapper" class="adk-message-wrapper hide">' +
                        '<div class="adk-message-icon"><div class="adk-message-icon-inner"></div></div>' +
                        '<div class="adk-message-text"></div>' +
                        '<div class="adk-message-close">x</div>' +
                    '</div>' //+
                // '</div>'
            );

            $element.append( $wrapper );
            $messageBody = $wrapper;//.find( ".adk-message-wrapper" );
            $messageText = $messageBody.find( ".adk-message-text" );
            $close = $messageBody.find( ".adk-message-close" );

            $close.on( "click", self.hide );
        }

        function runQueue() {
            if ( isProcessing ) return;
            isProcessing = true;
            processQueue()
        }

        function processQueue() {
            if( queue.some( function(i) { return !i.isShown; } ) ) {
                if ( queue[0].isShown ) {
                    self.hide();
                } else {
                    queue[0].show();
                }

                setTimeout( processQueue, animationDuration * 2 );

            } else {
                isProcessing = false;
            }
        }

        +function init( self ) {
            addItself(self);
        }( this );

        function QueueItem( message, type, duration ) {
            this.message = message;
            this.type = type;
            this.duration = duration;
            var self = this;
            this.isShown = false;

            this.show = function () {
                this.isShown = true;
                switch( this.type ) {
                    case 'success':
                        success();
                        break;
                    case 'error':
                        error();
                    break;
                    case 'progress':
                        progress();
                    break;
                }

                show();
            };

            this.hide = function () {
                hide();
            };

            function success() {
                $messageBody.removeClass("error action").addClass("success");
                $messageText.html( self.message );
            }

            function error() {
                $messageBody.removeClass("success action").addClass("error");
                $messageText.html( self.message );
            }

            function progress() {
                $messageBody.removeClass("error success").addClass("action");
                $messageText.html( self.message );
            }

            function show() {
                $messageBody.removeClass("hide").addClass("show");
            }

            function hide() {
                $messageBody.removeClass("show").addClass("hide");
                setTimeout( function () { $messageText.text( '' ); }, animationDuration );
            }
        }
    }

    return {
        init: function( element, locale ) {
            return new Message( element, locale );
        }
    };
} );