define( "stripe/method-slider", ["stripe/payment"], function( Payment ) {
    function Slider( element, loc ) {
        var $slider = $( element );
        var $innerPanel = $slider.find( ".adk-methods-slider-inner" );
        var $sliderPanel = $slider.find( ".adk-methods-header" );
        var $controlLeft = $slider.find( ".adk-header-slider-left");
        var $controlRight = $slider.find( ".adk-header-slider-right");
        var onSelect;
        var locale = loc;
        var sliderStatus = false;
        var self = this;

        this.onSelect = function( cb ) {
            onSelect = cb;
        };

        this.selectMethod = function( code ) {
            $sliderPanel.find( "#" + code ).trigger( "click" );
        };

        this.count = function() { return count(); };

        this.activateSomething = function () {
            if ( !this.has( 'card' ) ) {
                this.selectMethod( 'card' );

            } else {
                activateFirstOption();
            }
        };

        this.has = function( code) {
            $sliderPanel.find('[data-code="' + code + '"]').length > 0;
        };

        function activateFirstOption() {
            $sliderPanel.children().each( function ( index, item ) {
                if ( item.style.display !== "none" ) {
                    self.selectMethod( item.attributes['data-code'].value );
                    return false;
                }
            } );
        }

        function count() {
            var count = 0;

            $sliderPanel.children().each( function ( index, item ) {
                if ( item.style.display !== "none" ) count++;
            } );

            return count;
        }

        function slideLeft() {
            var offset = parseInt( $sliderPanel.css('left'), 10 );
            var offsetMax = 0;
            var newOffset = Math.min( offsetMax, getNewOffset()[1] );

            $sliderPanel.css( 'left', newOffset );
        }

        function slideRight() {
            var offset = parseInt( $sliderPanel.css('left'), 10 );
            var offsetMax = $innerPanel.outerWidth() - $sliderPanel.outerWidth();
            var newOffset = Math.max( offsetMax, getNewOffset()[0] );

            $sliderPanel.css( 'left', newOffset );
        }

        function getNewOffset() {
            var width = Math.round( $innerPanel.outerWidth() );
            var sliderWidth = Math.round( $sliderPanel.outerWidth() );
            var leftEdge = parseInt( $sliderPanel.css( 'left' ), 10 ) * -1;
            var rightEdge = leftEdge + width;
            var offset = [width - sliderWidth, 0];

            $sliderPanel.children().each( function (index, item ) {
                var pos = $( item ).position();
                var left = Math.round( pos.left );
                var right = Math.round( pos.left + $( item ).outerWidth() );

                if ( left <= rightEdge && right > rightEdge ) {
                    offset[0] = Math.round( width - right );
                }

                if ( left < leftEdge && right >= leftEdge ) {
                    offset[1] = Math.round( left * -1 );
                }
            } );

            return offset;
        }

        function onItemSelect( element ) {
            if ( $( element ).hasClass("active") ) return;

            $sliderPanel.find( "i" ).removeClass( "active" );
            $( element ).addClass( "active" );

            if ( onSelect ) onSelect( element.id );
        }

        function paymentRequestSupport() {
            $sliderPanel.find( "#payment_request" ).show();
            activateSlider();
            checkOptionsVisibility();
        }

        function activateSlider() {
            if ( sliderStatus ) return;

            if ( $sliderPanel.outerWidth() > $innerPanel.outerWidth() ) {
                sliderStatus = true;
                $slider.addClass( "with-slider" );
                $controlLeft.on( "click", slideLeft );
                $controlRight.on( "click", slideRight);
            }
        }

        function checkOptionsVisibility() {
            if ( count() === 1 ) {
                $slider.hide();

            } else {
                $slider.show();
            }
        }

        +function init( self ) {
            $( document ).on( "payment_request_support_on", paymentRequestSupport );
            $( document ).on( "payment_request_support_off", checkOptionsVisibility );

            $sliderPanel.on( "click", "i.payment-option-header-item", function(evt) {
                setTimeout( function() {
                    onItemSelect( evt.target.classList.contains( "payment-option-header-item") ? evt.target : evt.currentTarget );
                }, 500 ); } ); // we need it for once-step on Firefox (at least)

            checkOptionsVisibility();
            activateSlider();
        }( this );
    }

    return {
        init: function ( element, locale ) {
            element.adk_method_slider = new Slider( element, locale );
            return element.adk_method_slider;
        }
    };
} );