define( "stripe/pay_button", ["stripe/form", "adk" ] , function (Form, ADK ) {
    function PayButton() {
        var locale;

        this.run = function( loc ) {
            locale = loc;
            ADK.locale = loc;
            Form.init( $("#payment-form")[0], locale );
            getPrice();
            $( ".adk-one-click" ).on( "click", createOrder );
        };

        function getData() {
            var journalData = $( '#product .button-group-page input[type="text"], #product .button-group-page input[type="hidden"], #product .button-group-page input[type="radio"]:checked, #product .button-group-page input[type="checkbox"]:checked, #product .button-group-page select, #product .button-group-page textarea, ' +
                '#product .product-options input[type="text"], #product .product-options input[type="hidden"], #product .product-options input[type="radio"]:checked, #product .product-options input[type="checkbox"]:checked, #product .product-options select, #product .product-options textarea, ' +
                '#product select[name="recurring_id"]');

            var data = $('#product input[type=\'text\'], #product input[type=\'hidden\'], #product input[type=\'radio\']:checked, #product input[type=\'checkbox\']:checked, #product select, #product textarea');

            return journalData.length > data.length ? journalData : data;
        }

        $( "#adk-describe" ).on( "click", function(){
            var $details = $( "#adk-details" );

            if( $detais.is( ":visible" ) ) {
                $details.slideUp();
                $( this ).find( "i" ).removeClass( "fa-caret-up" ).addClass( "fa-caret-down" );

            } else {
                $details.slideDown();
                $( this ).find( "i" ).removeClass( "fa-caret-down" ).addClass( "fa-caret-up" );
            }
        } );

        function createOrder() {
            $button = $( this );

            $.ajax( {
                url: locale.createOrderUrl,
                type: 'post',
                data: getData(),
                dataType: 'json',
                beforeSend: function() {
                    $button.attr( "disabled", "true" );
                },
                complete: function() {
                    $button.removeAttr( "disabled" );
                },
                success: function(json) {
                    $('.alert, .text-danger').remove();
                    $('.form-group').removeClass('has-error');

                    if (json['error']) {
                        if (json['error']['option']) {
                            for (i in json['error']['option']) {
                                var element = $('#input-option' + i.replace('_', '-'));

                                if (element.parent().hasClass('input-group')) {
                                    element.parent().after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
                                } else {
                                    element.after('<div class="text-danger">' + json['error']['option'][i] + '</div>');
                                }
                            }
                        }

                        if (json['error']['recurring']) {
                            $('select[name=\'recurring_id\']').after('<div class="text-danger">' + json['error']['recurring'] + '</div>');
                        }

                        // Highlight any found errors
                        $('.text-danger').parent().addClass('has-error');

                    } else if ( json.errorMsg ) {
                        alert( json.errorMsg );

                    } else if (json['success']) {
                        $("#button-confirm" ).trigger("click");

                    } else {
                        alert( locale.scriptErrorMsg );
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }

        function getPrice() {
            $.post( locale.priceUrl, getData(), "json" )
                .done( function ( resp ) {
                    if ( resp.button_text ) {
                        $( "#adk-stripe-button i" ).html( resp.button_text );
                    }

                    if ( resp.description ) {
                        $( "#adk-details" ).html( resp.description );
                        $( "#adk-describe" ).css( "display", "block" );
                        locale.popUpButtonText = resp.button_text;
                    }

                    locale.total              = resp.total_cents;
                    locale.euroTotal          = resp.total_cents_euro;
                } );
        }

        $( document ).on( "change", '#product input:not(#payment-form input), #product select, #product textarea', getPrice );
    }

    return new PayButton();

});