define( "stripe/payment", [ "https://js.stripe.com/v3/" ], function() {
    function Payment() {
        var locale;
        var currentOption;
        var button;
        var message;
        var isPaymentProcessVar = false;

        var options = {
            card: {
                require: "stripe/payment/card",
                instance: null,
            },
            alipay: {
                require: "stripe/payment/alipay",
                instance: null,
            },
            bancontact: {
                require: "stripe/payment/bancontact",
                instance: null,
            },
            eps: {
                require: "stripe/payment/eps",
                instance: null,
            },
            giropay: {
                require: "stripe/payment/giropay",
                instance: null,
            },
            ideal: {
                require: "stripe/payment/ideal",
                instance: null,
            },
            multibanco: {
                require: "stripe/payment/multibanco",
                instance: null,
            },
            sofort: {
                require: "stripe/payment/sofort",
                instance: null,
            },
            wechat: {
                require: "stripe/payment/wechat",
                instance: null,
            },
            p24: {
                require: "stripe/payment/p24",
                instance: null,
            },
            payment_request: {
                require: "stripe/payment/payment_request",
                instance: null,
            }
        };

        this.setLocale = function ( loc, but, mess ) {
            locale = loc;
            button = but;
            message = mess;
            init( this );
        };

        function checkPaymentRequestSupport() {
            var stripe = Stripe( locale.pKey );
            var paymentRequest = stripe.paymentRequest( {
                country: locale.country,
                currency: locale.currency,
                total: {
                    label: locale.smartButtonLabel,
                    amount: locale.total,
                },
            } );

            return paymentRequest.canMakePayment();
        }

        this.onOptionSelect = function( code ) {
            var self = this;
            currentOption = code;

            if ( code === "payment_request" ) {
                button.hide();

            } else {
                button.show()
            }

            if ( options[ code ] ) {
                button.on();

                require([options[ code ]['require']], function(option) {
                    options[ code ]['instance'] = option.init( locale, self );
                    button.off();
                } );
            }
        };

        this.isPaymentProcessing = () => {
            return isPaymentProcessVar;
        }

        this.onPopUpHide = () => {
            button.off();
        }

        this.error = function (mes) {
            isPaymentProcessVar = false;
            message.error(mes);
            button.off();
        };

        this.success = function(mes){
            message.success(mes);
            //button.off();
        };

        this.info = function(mes){
            message.progress(mes);
        };

        this.pay = function() {
            isPaymentProcessVar = true;
            button.on();
            message.progress( locale.placingOrderMsg );
            options[currentOption]['instance'].pay();
        };

        this.finish = function () {
            isPaymentProcessVar = false;
            this.success( locale.orderSuccessMsg );
            onCharge();

            if ( !locale.isPayButton ) {
                setTimeout( function() {
                    window.location.assign( locale.successUrl );
                }, 5000 );
            }
        };

        this.enableButton = function () {
            button.enable();
        };

        this.disableButton = function() {
            button.disable();
        };

        this.getOwner = function() {
            var owner = { address: {} };
            var $nameInput = $( "#cc-name" );

            owner.name = $nameInput.length && $nameInput.val().length ? $nameInput.val() : locale.name;

            if ( locale.email ) {
                owner.email = locale.email;
            }

            if ( locale.telephone ) {
                owner.phone = locale.telephone;
            }

            if ( locale.city ) {
                owner.address.city = locale.city;
            }

            if ( locale.country ) {
                owner.address.country = locale.country;
            }

            if ( locale.line1 ) {
                owner.address.line1 = locale.line1;
            }

            if ( locale.line2 ) {
                owner.address.line2 = locale.line2;
            }

            if ( locale.zipCode ) {
                owner.address.postal_code = locale.zipCode;
            }

            return owner;
        };

        function onCharge() {
            $.getJSON( locale.chargeSuccessUrl, { isPayButton: locale.isPayButton } )
        }

        function init( self ) {
           try {
               checkPaymentRequestSupport().then( function( result ) {
                   if ( result ) {
                       $( document ).trigger( "payment_request_support_on" );

                   } else {
                       console.log('payment request not supported' );
                       $( document ).trigger( "payment_request_support_off" );
                   }
               } );

           } catch ( e ) {
               console.error( e );
               $( document ).trigger( "payment_request_support_off" );
           }

            button.onSubmit( self.pay );
        }
    }

    return new Payment();
} );