define( "stripe/payment/giropay", [] , function () {
    function Giropay( loc, pay ) {
        var locale = loc;
        var payment = pay;
        var stripe;

        this.pay = function() {
            createSource();
        };

        function createSource() {
            stripe.createSource({
                type:     'giropay',
                amount:   locale.euroTotal,
                currency: 'eur',
                redirect: {
                    return_url: locale.successUrl,
                },
                owner: payment.getOwner(),
                statement_descriptor: locale.statementDescriptor,
                metadata: locale.metadata,
            } ).then( function( result ) {
                console.log( result );
                if ( result.error ) {
                    payment.error( result.error.message );

                } else if ( result.source && result.source.status === "pending" && result.source.redirect && result.source.redirect.url ) {
                    location.assign( result.source.redirect.url );
                }
            } );
        }

        +function init( self ) {
            stripe = Stripe( locale.pKey );
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new Giropay( locale, payment );
        }
    }
} );