define( "stripe/payment/ideal", [], function() {
    function Ideal( loc, parent ) {
        var locale = loc;
        var card;
        var $cardField = $( "#ideal-bank-element" );
        var elements;
        var stripe;
        var payment = parent;

        this.pay = function() {
            pay();
        };

        function pay() {
            createIntent()
                .done( function( resp ) {
                    if ( resp.error ) {
                        payment.error( resp.error );

                    } else if ( resp.secret ) {
                        confirmIntent( resp.secret );

                    } else {
                        payment.error( locale.scriptErrorMsg );
                    }
                } )
                .fail( function() { payment.error( locale.scriptErrorMsg ) } );
        }

        function createIntent() {
            return $.post( locale.createSourceIntentUrl, { tag: "ideal" }, null, "json" );
        }

        function confirmIntent( sec ) {
            stripe.confirmIdealPayment( sec , {
                    payment_method: {
                        ideal: card,
                        billing_details: {
                            name: $( "#cc-name" ).val(),
                        },
                    },
                    return_url: locale.successUrl,
                } ).then( function( result ) {
                if (result.error) {
                    payment.error( result.error.message );
                }
            } );
        }

        function mountFields() {
            if ( card ) {
                card.mount( "#" + $cardField.attr( 'id' ) );
            }
        }

        function createFields() {
            if ( $cardField.length ) {
                card = elements.create( 'idealBank', {
                    style: getElementStyle(),
                } );
            }
        }

        function getElementStyle() {
            return {
                base: {
                    color: locale.inputColor,
                    '::placeholder': {
                        color: locale.inputColor
                    },
                    padding: '5px',
                }
            };
        }

        +function init( self ) {
            stripe = Stripe( locale.pKey );
            elements = stripe.elements();
            createFields();
            mountFields();
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new Ideal( locale, payment );
        }
    }
} );