define( "stripe/payment/p24", [] , function () {
    function P24( loc, pay ) {
        var locale = loc;
        var payment = pay;
        var stripe;

        this.pay = function() {
            createSource();
        };

        function createSource() {
            stripe.createSource({
                type:     'p24',
                amount:   locale.currency === "pln" ? locale.total : locale.euroTotal,
                currency: locale.currency === "pln" ? locale.currency : 'eur',
                redirect: {
                    return_url: locale.successUrl,
                },
                owner: payment.getOwner(),
                statement_descriptor: locale.statementDescriptor,
                metadata: locale.metadata,
            } ).then( function( result ) {
                console.log( result );
                if ( result.error ) {
                    payment.error( result.error.message );

                } else if ( result.source && result.source.status === "pending" && result.source.redirect && result.source.redirect.url ) {
                    location.assign( result.source.redirect.url );
                }
            } );
        }

        +function init( self ) {
            stripe = Stripe( locale.pKey );
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new P24( locale, payment );
        }
    }
} );