define( "stripe/payment/payment_request", [], function() {
    function PaymentRequest( loc, parent ) {
        var locale = loc;
        var button;
        var $buttonField = $( "#payment-request-button" );
        var elements;
        var stripe;
        var secret;
        var payment = parent;
        var paymentRequest;

        this.pay = function() {

        };

        function payOneTime() {
            if ( secret ) return;

            createIntent()
                .done( function( resp ) {
                    if ( resp.error ) {
                        // payment.error( resp.error );
                        console.error( resp.error )

                    } else if ( resp.secret ) {
                        secret = resp.secret;
                        $("#payment-request-button").show();

                    } else {
                        console.error( locale.scriptErrorMsg );
                    }
                } )
                .fail( function() { console.error( locale.scriptErrorMsg ) } );
        }

        function createIntent() {
            return $.post( locale.createRequestIntentUrl, {}, null, "json" );
        }

        function mountFields() {
            if ( button ) {
                button.mount('#payment-request-button');
            }
        }

        function createFields() {
            if ( $buttonField.length ) {
                button = elements.create( 'paymentRequestButton', {
                    paymentRequest: paymentRequest,
                    style: {
                        paymentRequestButton: {
                            type: 'default', // One of 'default', 'book', 'buy', or 'donate'
                            theme: 'dark',   // One of 'dark', 'light', or 'light-outline'
                            height: '64px'   // Defaults to '40px'. The width is always '100%'.
                        }
                    }
                } );
            }
        }

        function checkSupport() {
            paymentRequest.canMakePayment().then( function ( result ) {
                console.log( result );
                if ( result ) {
                    mountFields();
                    $('#payment-request-wrapper').show();
                    payOneTime();
                }
            } );
        }

        function createPaymentRequest() {
            paymentRequest = stripe.paymentRequest( {
                country: locale.country,
                currency: locale.currency,
                requestPayerName: true,
                requestPayerEmail: true,
                requestPayerPhone: true,
                total: {
                    label: locale.smartButtonLabel,
                    amount: locale.total,
                },
            } );

            paymentRequest.on( 'paymentmethod', function( ev ) {
                stripe.confirmCardPayment(
                    secret,
                    {payment_method: ev.paymentMethod.id},
                    {handleActions: false}

                ).then( function( confirmResult ) {
                    if ( confirmResult.error ) {
                        payment.error( confirmResult.error );
                        ev.complete('fail');

                    } else {
                        ev.complete('success');

                        stripe.confirmCardPayment( secret ).then( function( result ) {
                            if (result.error) {
                                payment.error( result.error.message );

                            } else {
                                payment.finish();
                            }
                        } );
                    }
                } );
            } );

            paymentRequest.on( 'cancel', function( ev ) {
                payment.error( 'Cancelled by customer' );
            } );
        }

        +function init( self ) {
            $("#payment-request-button").hide();
            stripe = Stripe( locale.pKey );
            elements = stripe.elements();
            createPaymentRequest();
            createFields();
            checkSupport();
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new PaymentRequest( locale, payment );
        }
    }
} );