define( "stripe/payment/sofort", [] , function () {
    function Sofort( loc, pay ) {
        var locale = loc;
        var payment = pay;
        var stripe;

        this.pay = function() {
            createSource();
        };

        function createSource() {
            stripe.createSource({
                type:     'sofort',
                amount:   locale.euroTotal,
                currency: 'eur',
                redirect: {
                    return_url: locale.successUrl,
                },
                owner: payment.getOwner(),
                statement_descriptor: locale.statementDescriptor,
                metadata: locale.metadata,
                sofort: {
                    country: locale.country,
                },
            } ).then( function( result ) {
                console.log( result );
                if ( result.error ) {
                    payment.error( result.error.message );

                } else if ( result.source && result.source.status === "pending" && result.source.redirect && result.source.redirect.url ) {
                    location.assign( result.source.redirect.url );
                }
            } );
        }

        +function init( self ) {
            stripe = Stripe( locale.pKey );
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new Sofort( locale, payment );
        }
    }
} );