define( "stripe/payment/wechat", ["adk", "qrcode/jquery-qrcode.min"] , function (ADK, QrCode) {
    function Wecaht( loc, pay ) {
        var locale = loc;
        var payment = pay;
        var stripe;

        this.pay = function() {
            createSource();
        };

        function createSource() {
            stripe.createSource({
                type:     'wechat',
                amount:   locale.total,
                currency: locale.currency,
                owner: payment.getOwner(),
                statement_descriptor: locale.statementDescriptor,
                metadata: locale.metadata,
            } ).then( function( result ) {
                if ( result.error ) {
                    payment.error( result.error.message );

                } else {
                    showQrCode( result.source.wechat.qr_code_url );
                    pollSource( result.source.id, result.source.client_secret );
                }
            } );
        }

        function pollSource( id, secret ) {
            stripe
                .retrieveSource({
                    id: id,
                    client_secret: secret,
                })
                .then(function(result) {
                    if ( "consumed" === result.source.status ) {
                        payment.finish();
                        return;
                    } else if ( "failed" === result.source.status ) {
                        payment.error( locale.orderErrorMsg );
                        return;
                    }
                    // else if ( "chargeable" === result.source.status ) { debugger
                    //     stripe.confirmPaymentIntent( result.source.client_secret )
                    //         .then( result => console.log( result ), error => console.error( error ) )
                    // }

                    setTimeout( function() {pollSource(id,secret)}, 1000 );
                });
        }

        function showQrCode( text ) {
            if ( ADK.isMobile() ) {
                location.assign( text );
                return;
            }

            $( ".wechat" ).empty().append(
                ($( "<div style='display: flex; justify-content: center;'/>" ).qrcode( { text: text } ) )
            );
        }

        +function init( self ) {
            stripe = Stripe( locale.pKey );
        }( this );
    }

    return {
        init: function (locale, payment ) {
            return new Wecaht( locale, payment );
        }
    }
} );