define( "stripe/recurring_buttons", ["alert", "button", "adk"], function ( Alert, Button, ADK ) {
    function Buttons() {
        var locale;

        this.run = function( loc ) {
            locale = loc;
            Alert.setLocale( loc );
            ADK.locale = loc;
        };

        $(document).on( "click", "#adk-cancel-period, #adk-cancel-now", function() {
            Alert.confirm( locale.cancelSubscriptionText ).yes( cancel.bind( this ) );
        } );

        function cancel() {
            Button.url( $( this ), { order_recurring_id: locale.order_recurring_id, } )
                .done( function () {
                    $("#adk-refresh").click();
                } );
        }

        $(document).on( "click", "#adk-refresh", function() {
            Button.url($(this), { order_recurring_id: locale.order_recurring_id, } )
                .done(function (resp) {
                    $('body').find( '#content' ).html( $( resp.html ).find( '#content' ).html() );
                });
        } );
    }

    return new Buttons();
});