<?php
/**
 * Advertikon sessionmessage.php Class
 * @author Advertikon
 * @package
 * @version 5.0.44  
 */

namespace Advertikon;


use Advertikon\Element\Bootstrap\Message;

class SessionMessage {
	const TAG = "adk_message";

	/**
	 * @param $message
	 * @param int $type
	 */
	static public function add( $message, $type = Message::INFO ) {
		try {
			$a = Advertikon::instance();
			$data = isset( $a->session->data[self::TAG] ) ? $a->session->data[self::TAG] : [];
			$data[] = [ $message, $type ];
			$a->session->data[self::TAG] = $data;
		} catch (\Exception $e ) {} // adding error report shouldn't raise another error
	}

	/**
	 * @return string
	 * @throws Exception
	 */
	static public function showAll() {
		$a = Advertikon::instance();
		$data = isset( $a->session->data[self::TAG] ) ? $a->session->data[self::TAG] : [];
		$ret = [];

		foreach ( $data as $datum ) {
			$ret[] = (new Message( $datum[0], $datum[1] ) )->render();
		}

		$a->session->data[self::TAG] = [];

		return implode( "\n", $ret );
	}
}