<?php

/**
 * @package Advertikon_stripe
 * @author Advertikon
 * @version 5.0.44          
 */

namespace Advertikon\Stripe;

/**
 * Compatibility checker
 *
 * @author Advertikon
 */
class Compatibility_Check extends \Advertikon\Compatibility_Check {
	private static $name = 'Stripe';
	
	protected function check() {
		parent::check();
		$this->errors[ self::$name ] = [];

		// CURL library presence
		if ( $this->test_mode || ! function_exists( 'curl_version' ) ) {
			$this->errors[ self::$name ][] = 'PHP CURL library required' . '. ' .
			sprintf(
				'%s<a href="%s" target="_blank">%s</a>',
				'Follow this link to ',
				'http://php.net/manual/book.curl.php',
				'get more details'
			);
		}

		// CURL SSL support
		else {
			$cv = curl_version();

			if (
				$this->test_mode ||
				isset( $cv['features'] ) &&
				! ( $cv['features'] & CURL_VERSION_SSL )
			) {
				$this->errors[ self::$name ][] =  'SSL support for PHP CURL library needs to be enabled' . '. ' .
				sprintf(
					'%s<a href="%s" target="_blank">%s</a>',
					'Follow this link to ',
					'http://php.net/manual/book.curl.php',
					'get more digitals'
				);
			}
		}

		// JSON library support
		if (  $this->test_mode || ! function_exists( 'json_decode' ) ) {
			$this->errors[ self::$name ][] =  'PHP JSON library required' . '. ' .
			sprintf(
				'%s<a href="%s" target="_blank">%s</a>',
				'Follow this link to ',
				'http://php.net/manual/book.json.php',
				'get more ditails'
			);
		}

		// MBString library support
		if (  $this->test_mode || ! function_exists( 'mb_detect_encoding' ) ) {
			$this->errors[ self::$name ][] = 'PHP Multi-byte String library required' . '. ' .
			sprintf(
				'%s<a href="%s" target="_blank">%s</a>',
				'Follow this link to ',
				'http://php.net/manual/book.mbstring.php',
				'get more ditails'
			);
		}
	}
}
