<?php
/**
 * Advertikon Stripe Option Class
 * @author Advertikon
 * @package Advertikon
 * @version 5.0.44      
 */

namespace Advertikon\Stripe;

/**
 * Class Option
 * @package Advertikon\Stripe
 * @method array next_year
 * @method array payment_option
 * @method array stripe_account
 * @method array payment_system
 * @method array input_appearance
 */
class Option extends \Advertikon\Option {

	/**
	 * Returns years' sequence $from up to $count counts
	 * @param int $count Years count
	 * @param int|null $from Year to start from
	 * @return array
	 * @throws Exception
	 */
//	public function get_next_year( $count, $from = null ) {
//		$ret = array();
//
//		if ( ! is_numeric( $count ) ) {
//			$mess = sprintf( 'Numeric count expected, "%s" given instead', gettype( $count ) );
//			trigger_error( $count );
//			throw new Exception( $mess );
//		}
//
//
//		if ( is_null( $from ) ) {
//			$from = date( 'Y' );
//
//		} elseif ( ! is_numeric( $from ) ) {
//			$mess = sprintf( 'Expected numeric year value, "%s" given instead', gettype( $from ) );
//			trigger_error( $mess );
//			throw new Exception( $mess );
//		}
//
//		for( $len = $from + $count; $from < $len; $from++ ) {
//			$ret[ $from ] = $from;
//		}
//
//		return $ret;
//	}

	/**
	 * Returns list of available payment options
	 * @return array
	 * @throws \Advertikon\Exception
	 */
	public function get_payment_option() {
		return array(
			Advertikon::PAYMENT_AUTHORIZE         => ADK( __NAMESPACE__ )->__( 'Authorize' ),
			Advertikon::PAYMENT_AUTHORIZE_CAPTURE => ADK( __NAMESPACE__ )->__( 'Capture' ),
			Advertikon::PAYMENT_FRAUD_CHECK       => ADK( __NAMESPACE__ )->__( 'Authorize if fraud' ),
		);
	}

	/**
	 * Returns list of Stripe accounts
	 * @return array
	 * @throws \Advertikon\Exception
	 */
//	public function get_stripe_account() {
//		$ret = array();
//
//		foreach( ADK( __NAMESPACE__ )->config( 'account', array() ) as $code => $account ) {
//			$ret[ $code ] = $account['account_name'];
//		}
//
//		return $ret;
//	}

	/**
	 * Returns list of payment systems supported by Stripe
	 * @return array
	 */
//	public function get_payment_system() {
//		$ret = array(
//			'visa'       => 'Visa',
//			'mastercard' => 'MasterCard',
//			'amex'       => 'American Express',
//			'jcb'        => 'JCB',
//			'discover'   => 'Discover',
//			'diners'     => 'Diners Club',
//		);
//
//		if ( class_exists( 'Advertikon\Stripe\Extended' ) ) {
//			foreach( Advertikon::SUPPORTED_METHODS as $m ) {
//				$ret[ $m ] = ucfirst( $m );
//			}
//		}
//
//		return $ret;
//	}

	/**
	 * Returns list of available appearances of payment card number input field
	 * @return array
	 * @throws \Advertikon\Exception
	 */
	public function get_input_appearance() {
		return array(
			'formated'     => ADK( __NAMESPACE__ )->__( 'Formatted' ),
			'plain'        => ADK( __NAMESPACE__ )->__( 'Plain' ),
			'plain_mobile' => ADK( __NAMESPACE__ )->__( 'Plain if mobile' ),
			'plain_apple'  => ADK( __NAMESPACE__ )->__( 'Plain if Apple' ),
		);
	}

}
