<?php


namespace Advertikon\Stripe;


use Advertikon\Element\Div;
use Advertikon\Element\Image;
use Advertikon\Element\Input;
use Advertikon\Element\Slider;
use Advertikon\Element\Span;
use Advertikon\Element\Style;
use Advertikon\Element\Text;
use Advertikon\Setting;

class PaymentForm {

    /** @var Advertikon */
    private $a;

    private $forPaymentButton = false;

	/**
	 * PaymentForm constructor.
	 * @param bool $forPaymentButton
	 * @throws \Advertikon\Exception
	 */
    public function __construct( $forPaymentButton = false ) {
        $this->a = Advertikon::instance();
        $this->forPaymentButton = $forPaymentButton;
    }

	/**
	 * @throws \Advertikon\Exception
	 * @throws \Exception
	 */
    public function getData() {
        $form_max_width     = $this->a->config( 'form_width', Slider::def( null, null, 500 )  );
        $form_border_radius = $this->a->config( 'border_radius', Slider::def(null,null,0 )  );
        $shadow_blur        = $this->a->config( 'form_shadow_blur', Slider::def(null,null,0) );
        $form_shadow        = $this->a->config( 'form_shadow' );
        $form_padding       = $this->a->config( 'form_padding', Slider::def(null,null,10) );
        $topMargin       = $this->a->config( 'form_margin_top', Slider::def(null,null,0) );
        $secondary_color    = self::secondaryColor();
        $paymentOptionsBgColor = Setting::get( 'form_header_bg_color', $this->a );
        $headerTextColor = Setting::get( 'form_header_text_color', $this->a );
        $textColor = Setting::get( 'form_text_color', $this->a );
        $form_border        = $this->a->config( 'form_border', Slider::def(null,null,1) );

        $boxShadowText = sprintf( '%1$s %1$s %2$s black', Slider::getMax( $form_shadow ), Slider::getMax( $shadow_blur ) );

        $data['formWrapperCss'] = (new Style(new Input()))
	        ->width( Slider::getMax( $form_max_width ) )
	        ->borderRadius( Slider::getMax( $form_border_radius ) )->stop()
	        ->boxShadow( $boxShadowText )->stop()
            ->filter()->dropShadow( $boxShadowText )->stop()
            ->backgroundColor( $this->a->config( 'form_background', '#fff' ) )
            ->color( $textColor )
            ->border( "solid " . Slider::getMax( $form_border ) . " $secondary_color" )->stop()
            ->display( 'none' )
            ->render();

	    $data['formCss'] = (new Style(new Input()))
		    ->padding( Slider::getMax( $form_padding ) )->stop()
		    ->render();

        $data['paymentOptionsHeaderCss'] = (new Style(new Input()))
            ->backgroundColor( $paymentOptionsBgColor )
            ->color( $headerTextColor )
            ->render();

        $data['contentCss'] = (new Style(new Input()))
            ->margin()->top(Slider::getMax($topMargin))->important()->stop()
            ->render();

        $data['templatePath'] = "default/template/{$this->a->type}/advertikon/stripe/";
        $data['secondary_color']              = $secondary_color;
        $data['border_bottom']                = sprintf( 'border-bottom: solid 1px %s;', $secondary_color );
        $data['background_secondary_color']   = sprintf( 'background-color: %s;', $secondary_color );
        $data['secondary_font_color']         = sprintf( 'color: %s;', $secondary_color );
        $data['font_color']                   = sprintf( 'color: %s;', $this->a->config( 'form_font_color',
            '#000' ) );
        $data['image']                        = class_exists( 'Advertikon\Stripe\Extended' ) ? Extended::image() : '';
        $data['payment_request_button_width'] = Setting::get( 'payment_request_button_width', $this->a, 300 );
        $data['payment_methods']              = PaymentOption::getAllEnabled();
        $data['card_logos_images']            = $this->a->isExtended ? Extended::cardLogos() : '';
        $data['paymentOptions']               = PaymentOption::getAllEnabled();
        $data['optionSliderLeft']             = $this->optionSliderLeft();
        $data['optionSliderRight']            = $this->optionSliderRoght();
        $data['confirmButton']                = $this->formButton();
        $data['additionalButton']             = $this->additionalButton();
        $data['inputCss']                     = self::inputCss()->margin()->bottom('10px!important')->stop();
        $data['hasRecurring']                 = $this->a->cart->hasRecurringProducts();

        return $data;
    }

	/**
	 * @return Style
	 * @throws \Advertikon\Exception
	 * @throws \Exception
	 */
    static public function inputCss() {
    	$a = Advertikon::instance();
	    $cardInputBorderWidth  = Setting::get('card_input_border', $a, Slider::def(null,null,1) );
	    $cardInputBorderColor  = Setting::get( 'card_input_border_color', $a, '#000' );
	    $cardInputBorderRadius = Setting::get('card_input_border_radius', $a,  Slider::def(null,null,0) );
	    $cardInputBgColor      = Setting::get( 'card_input_bg', $a, '#fff' );
	    $cardInputColor        = Setting::get( 'card_input_text_color', $a, '#000' );
	    $cardInputPadding      = Setting::get('card_input_padding', $a, Slider::def(null,null,0) );

	    return (new Style(new Input()))
		    ->border()
		        ->width( Slider::getMax( $cardInputBorderWidth ) )
		        ->color( $cardInputBorderColor )
		        ->important()
		        ->stop()
		    ->borderRadius( Slider::getMax( $cardInputBorderRadius ) )->important()->stop()
		    ->backgroundColor( $cardInputBgColor . '!important' )
		    ->color( $cardInputColor . '!important' )
		    ->padding( Slider::getMax( $cardInputPadding ) )->important()->stop();
    }

	/**
	 * @return mixed|null
	 * @throws \Advertikon\Exception
	 */
    static public function secondaryColor() {
	    return Setting::get( 'form_secondary_color', Advertikon::instance(), '#204d74' );
    }

    /**
     * @return \Advertikon\Element\Element
     * @throws \Advertikon\Exception
     */
    private function optionSliderLeft() {
        return (new Span( new Image( $this->a->u()->path_to_url( PaymentOption::$iconFolder . 'left_arrow.png' ) ) ) )
            ->getClass()->add( 'adk-header-slider-left adk-header-slider-item' );
    }

    /**
     * @return \Advertikon\Element\Element
     * @throws \Advertikon\Exception
     */
    private function optionSliderRoght() {
        return (new Span( new Image( $this->a->u()->path_to_url( PaymentOption::$iconFolder . 'left_arrow.png' ) ) ) )
            ->getClass()->add( 'adk-header-slider-right adk-header-slider-item' );
    }

    /**
     * @throws \Exception
     */
    private function formButton() {
    	$buttonAlign = Setting::get('confirm_button_alignment', $this->a, 'right' );
    	$buttonWidth = Setting::get( 'confirm_button_width', $this->a, Slider::def(null,null,100 ) );

        $button = (new \Advertikon\Element\Bootstrap\Button())
            ->isPrimary()
            ->getClass()->add( 'adk-confirm adk-button' )
	        ->style()->width( Slider::getMax( $buttonWidth ) )->stop()
            ->attributes()->set( [
                'data-loading-text' => $this->a->__( 'Processing' ),
                'disabled'          => 'disabled'
            ] );

        $div = (new Div( $button ))->getClass()->add( 'adk-confirm-button-wrapper' );

        if ( $this->isPopUp() ) {
            $button->children( new Text( str_replace( '{{amount}}', '', $this->a->__('caption_button_caption') ) ) );

        } else {
            $button->id( 'button-confirm' );
            $button->children( new Text( $this->a->__('caption_confirm_caption') ) );

	        if ( Setting::get( 'hide_button', $this->a ) ) {
		        $div->style()->display('none!important' );
	        }
        }

        if ( Setting::get( 'button_class', $this->a ) ) {
            $button->style()->raw( Setting::get('button_class', $this->a ) );
        }

        if ( 'right' === $buttonAlign ) {
        	$div->style()->justifyContent('flex-end' );

        } else if ( 'left' === $buttonAlign ) {
	        $div->style()->justifyContent('flex-start' );

        } else {
	        $div->style()->justifyContent('center' );
        }

        return $div;
    }

	/**
	 * @return \Advertikon\Element\Element
	 * @throws \Exception
	 */
    private function additionalButton() {
	    $buttonAlign = Setting::get('confirm_button_alignment', $this->a, 'right' );
	    $buttonWidth = Setting::get( 'confirm_button_width', $this->a, Slider::def(null,null,100 ) );

	    $button = (new \Advertikon\Element\Bootstrap\Button())
		    ->isPrimary()
		    ->getClass()->add( 'adk-show-popup adk-button' )
		    ->style()->width( Slider::getMax( $buttonWidth ) )->stop();

	    $div = (new Div( $button ))->getClass()->add( 'adk-confirm-button-wrapper' );

	    if ( Setting::get( 'hide_button', $this->a ) || $this->forPaymentButton ) {
		    $div->style()->display('none!important' );
	    }

	    $button->id( 'button-confirm' );
	    $button->children( new Text( $this->a->__('caption_confirm_caption') ) );

	    if ( Setting::get( 'button_class', $this->a ) ) {
		    $button->style()->raw( Setting::get('button_class', $this->a ) );
	    }

	    if ( 'right' === $buttonAlign ) {
		    $div->style()->justifyContent('flex-end' );

	    } else if ( 'left' === $buttonAlign ) {
		    $div->style()->justifyContent('flex-start' );

	    } else {
		    $div->style()->justifyContent('center' );
	    }

	    return $div;
    }

    public function isPopUp() {
    	return $this->a->isExtended && ( $this->forPaymentButton || Setting::get('popup', $this->a, false ) );
    }
}