<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class Alipay extends PaymentOption {
    public $tag = PaymentOption::ALIPAY;
    public $title = 'Alipay';

    function icon() {
        return PaymentOption::$iconFolder . 'alipay.svg';
    }

    /**
     * @throws \Advertikon\Exception
     */
    public function formBody() {
        $div = parent::formBody();
        $div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
        return $div;
    }
}