<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class Bancontact extends PaymentOption {
    public $tag = PaymentOption::BANCONTACT;
    public $title = 'Bancontact';

    function icon() {
        return PaymentOption::$iconFolder . 'bancontact.svg';
    }

	/**
	 * @throws \Advertikon\Exception
	 */
	public function formBody() {
		$div = parent::formBody();
		$div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
		return $div;
	}
}