<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class Giropay extends PaymentOption {
    public $tag = PaymentOption::GIROPAY;
    public $title = 'Giropay';

    function icon() {
        return PaymentOption::$iconFolder . 'giropay.svg';
    }

	/**
	 * @throws \Advertikon\Exception
	 */
	public function formBody() {
		$div = parent::formBody();
		$div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
		return $div;
	}
}