<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Div;
use Advertikon\Element\Hr;
use Advertikon\Element\Image;
use Advertikon\Element\Label;
use Advertikon\Setting;
use Advertikon\Stripe\Customer;
use Advertikon\Stripe\Exception;
use Advertikon\Stripe\Extended;
use Advertikon\Stripe\OrderPrice;
use Advertikon\Stripe\PaymentForm;
use Advertikon\Stripe\PaymentOption;

class Ideal extends PaymentOption {
    public $tag = PaymentOption::IDEAL;
    public $title = 'Ideal';

    function icon() {
        return PaymentOption::$iconFolder . 'ideal.svg';
    }

    /**
     * @param array $data
     * @return array
     * @throws Exception
     * @throws \Advertikon\Exception
     */
    public function getIntentData( array $data = [] ) {
        if ( !isset( $this->a->session->data['order_id'] ) ) {
            throw new Exception( 'Order is missing' );
        }

        $orderId = $this->a->session->data['order_id'];
        $orderPrice = new OrderPrice();
        $stripeCustomer = Customer::get();

        $intent_data = array_merge_recursive( [
            'amount'               => $orderPrice->totalEuro( true ),
            'currency'             => 'eur',
            'payment_method_types' => [ 'ideal' ],
            'metadata'             => $this->a->getMetadata( ['order_id' => $orderId ] ),
            'description'          => $this->a->shortcode()->do_shortcode( Setting::get( 'charge_description', $this->a ) ),
            'statement_descriptor' => Setting::get( 'statement_descriptor', $this->a ) ?: null,
        ], $data );


        if ( $stripeCustomer->exists() ) {
            $intent_data['customer'] = $stripeCustomer->stripeId();
        }

        if ( Setting::get( 'receipt_email', $this->a ) ) {
            $intent_data['receipt_email'] = $this->a->shortcode()->shortcode_customer_email();
        }

        return $intent_data;
    }

    /**
     * @throws \Advertikon\Exception
     * @throws \Exception
     */
    public function formBody() {
        $div = parent::formBody();
        $cardholder = $this->a->isExtended ? Extended::cardholderName() : '';
        $cardFields = $this->cardInputs();

        if ( $cardholder ) {
            $div->children( $cardholder );
        }

        if ( $cardFields ) {
            $div->children( $cardFields );
        }

        return $div;
    }

    private function cardInputs() {
        $div = new Div();

        $label = (new Label(  $this->a->__('iDEAL Bank' ) ))->forId( 'ideal-bank-element' );
        $inputDiv = (new Div())->id('ideal-bank-element');

        $div->children($label);
        $div->children($inputDiv);

        return $div;
    }
}