<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class Multibanco extends PaymentOption {
    public $tag = PaymentOption::MULTIBANKO;
    public $title = 'Multibanco';

    function icon() {
        return PaymentOption::$iconFolder . 'multibanco.svg';
    }

	/**
	 * @throws \Advertikon\Exception
	 */
	public function formBody() {
		$div = parent::formBody();
		$div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
		return $div;
	}
}