<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class P24 extends PaymentOption {

    public $tag = PaymentOption::P24;
    public $title = 'Przelewy24';

    function icon() {
        return PaymentOption::$iconFolder . 'p24.svg';
    }

    /**
     * @throws \Advertikon\Exception
     */
    public function formBody() {
        $div = parent::formBody();
        $div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
        return $div;
    }

}