<?php


namespace Advertikon\Stripe\PaymentOption;


use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;

class Sofort extends PaymentOption {
    public $tag = PaymentOption::SOFORT;
    public $title = 'Sofort';

    function icon() {
        return PaymentOption::$iconFolder . 'sofort.svg';
    }

	/**
	 * @throws \Advertikon\Exception
	 */
	public function formBody() {
		$div = parent::formBody();
		$div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
		return $div;
	}
}