<?php


namespace Advertikon\Stripe\PaymentOption;

use Advertikon\Element\Image;
use Advertikon\Stripe\PaymentOption;


class WeChat extends PaymentOption {
    public $tag = PaymentOption::WECHAT;
    public $title = 'WeChat';

    function icon() {
        return PaymentOption::$iconFolder . 'wechat.svg';
    }

	/**
	 * @throws \Advertikon\Exception
	 */
	public function formBody() {
		$div = parent::formBody();
		$div->children( (new Image( $this->a->u()->path_to_url( $this->icon() ) ) ) );
		return $div;
	}
}