<?php
/**
 * Advertikon Short-code Class
 * @author Advertikon
 * @package Stripe
*@version5.0.44
4
 */

namespace Advertikon\Stripe;

class Shortcode extends \Advertikon\Shortcode {
	
	public function __construct(\Advertikon\Advertikon $a) {
		parent::__construct($a);
		
		$this->shortcode_set = array_merge( array(
			'products' => array(
				'callback'    => array( $this, 'shortcode_products' ),
				'hint'        => 'products',
				'description' => $this->a->__( 'Shows order\'s products' ),
				'context'     => array( $this->a->__( 'Customer' ), $this->a->__( 'Dashboard'), $this->a->__( 'Affiliate' ) ),
			),
		), $this->shortcode_set );
	}

	/**
	 * Returns list of products name for order
	 * @paran string $name Shortcode name
	 * @param int $order_id Order ID. If omitted current order is used
	 * @return string
	 */
	public function shortcode_products( $name, $order_id = null ) {
		$ret = '';
		
		if ( is_null( $order_id ) ) {
			if ( !isset( $this->a->session->data['order_id'] ) ) {
				return $ret;
			}
			
			$order_id = $this->a->session->data['order_id'];
		}

		$order = $this->a->get_order( $order_id );

		if ( !$order ) {
			return $ret;
		}

		return implode( ", ", array_map( function( $product ) {
			$name     = $product['name'];
			$options  = [];
			$quantity = $product['quantity'];

			foreach( $product['options'] as $option ) {
				foreach( $option['values'] as $value ) {
					$options[] = $option['option_name'] . ': ' . $value['option_value'];
				}
			}

			return sprintf( "%s %s - %d", $name, $options ? '(' . implode( ', ', $options ) . ')' : '', $quantity );
		}, $order['products'] ) );
	}
}
