<?php
namespace Advertikon\Stripe;

class Twig extends \Advertikon\Twig {
	protected function add( \Advertikon\Advertikon $a ) {
		parent::add( $a );

		$cardname_func = new \Twig_SimpleFunction( 'card_name', function ( $card ) use ( $a ) {
		    return '**** ' . $card->last4 .	' (' . str_pad( $card->exp_month, 2, '0', STR_PAD_LEFT ) .
						'/' . $card->exp_year . ')';
		} );

		$this->twig->addFunction( $cardname_func );

		$is_in_session_func = new \Twig_SimpleFunction( 'is_in_session', function ( $path ) use ( $a ) {
			if ( !$path ) return false;

			$path = explode( '/', $path );
			$base = $a->session->data;

			while ( $path ) {
				$part = array_shift( $path );

				if ( ! isset( $base[ $part ] ) ) {
					return false;
				}

				$base = $base[ $part ];
			}

		    return true;
		} );

		$this->twig->addFunction( $is_in_session_func );

		$get_from_session_func = new \Twig_SimpleFunction( 'get_from_session', function ( $path ) use ( $a ) {
			if ( !$path ) return null;

			$path = explode( '/', $path );
			$base = $a->session->data;

			while ( $path ) {
				$part = array_shift( $path );

				if ( ! isset( $base[ $part ] ) ) {
					return null;
				}

				$base = $base[ $part ];
			}

		    return $base;
		} );

		$this->twig->addFunction( $get_from_session_func );
	}
}