<?php

namespace vendor\isenselabs\autodetect;

class CurrencyLib extends \AutoDetect_SystemLibraryCartCurrencyAlias {

	use \vendor\isenselabs\autodetect\LibraryReplacementHelper;

    private $config;
    private $session;
    private $db;

	public function __construct($registry, &$original = null) {
        // initializes LibraryReplacementHelper, sets up forwarding to the original cart library where necessary
        if (is_object($original)) {
		    $this->initializeReplacement($original);
        } else {
            $original = $registry->get('currency');
            $this->initializeReplacement($original);
        }
		$this->config = $registry->get('config');
		$this->session = $registry->get('session');
        $this->db = $registry->get('db');

        $ad_config = $this->config->get('AutoDetect');
        
        if(!empty($ad_config['DetectMethod']) && $ad_config['DetectMethod'] == 'sync') {
           if (empty($this->session->data['autodetect_detectedlanguage']) || empty($this->session->data['autodetect_detectedredirectto']) || empty($this->session->data['autodetect_detectedcurrency'])) {
                $detect_res = $this->detect();
                $languageToBeChanged = (!empty($detect_res['languageto']) && empty($this->session->data['autodetect_detectedlanguage']));
                $currencyToBeChanged = (!empty($detect_res['currencyto']) && empty($this->session->data['autodetect_detectedcurrency']));
                if ($languageToBeChanged) {
                    $this->session->data['autodetect_detectedlanguage'] = $detect_res['languageto'];
                    $this->session->data['language'] = $detect_res['languageto'];
                    
                    $languages = array();

                    $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "language` WHERE status = '1'");
                    
                    foreach ($query->rows as $result) {
                        $languages[$result['code']] = $result;
                    }
                    
                    $this->config->set('config_language_id', $languages[$detect_res['languageto']]['language_id']);
                    $this->config->set('config_language', $detect_res['languageto']);
                }

                if ($currencyToBeChanged) {
                    $this->session->data['autodetect_detectedcurrency'] = $detect_res['currencyto'];
                    $this->session->data['currency'] = $detect_res['currencyto'];
                }
            }
        }
	}

	public function detect() {
        $resp = array();

        if (!isset($_SERVER['REMOTE_ADDR'])) {
            $res = array('error'=>'true');
            return $res;

        }

        if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];             
        } else if(!empty($_SERVER['REMOTE_ADDR'])) {
                    $ip = $_SERVER['REMOTE_ADDR'];  
        } else {
                    $ip = "";
        }   

        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            $ip = '';
        }

        $config = $this->config->get('AutoDetect');

        if (!isset($config['Enabled']) || $config['Enabled'] != 'yes') {
            return;
        }
        
        if(!empty($config["SearchEngines"]) && $config["SearchEngines"]=="no") {
            if($this->isBot()) return;
        }

        $result = $this->getCountryByIp($ip);

        $country_of_the_visitor = 'xxx';

        if (isset($result[0]['country'])) {
            $country_of_the_visitor = $result[0]['country'];

        }
        
        $res = array(
	        'languageto'=>'',
	        'currencyto'=>'',
	        'redirectto'=>'',
	        'syncmethod'=>''
        );

        if (!isset($config['Language'])) {
            $config['Language'] = array();
        }


        if (!isset($config['Currency'])) {
            $config['Currency'] = array();
        }

        if (!isset($config['RedirectTo'])) {
            $config['RedirectTo'] = array();
        }

        foreach ($config['Language'] as $k => $l) {
            if (strpos(strtoupper($l),strtoupper($country_of_the_visitor)) !== false) {
                $res['languageto'] = $k;
            }
        }

        foreach ($config['Currency'] as $k => $l) {
            if (strpos(strtoupper($l),strtoupper($country_of_the_visitor)) !== false) {
                $res['currencyto'] = $k;
            }
        }

        $res['syncmethod'] = $config['DetectMethod'];

        foreach ($config['RedirectTo'] as $k => $l) {
            if (strpos(strtoupper($l['countries']),strtoupper($country_of_the_visitor)) !== false) {
                $res['redirectto'] = $l['link'];
                if(isset($l['manual_redirect'])) {
                    $res['manual_redirect'] = $l['manual_redirect'];
                    $res['stripe_text'] = $l['stripe_text'];
                    $res['button_text'] = $l['button_text'];
                }
            }
        }
        return $res;
    }

    public function getCountryByIp($ip) {
        $json = file_get_contents('https://oc.ip2person.com/ip2country.php?ip='.$ip);
        $source = json_decode($json);

        if (!empty($source->country)) {
            return $source->country;
        }

        return '';
    }
    
    public function isBot(){
        if (!isset($_SERVER['HTTP_USER_AGENT'])) {
            return false;   
        }
        $bots = array(
            'Googlebot', 'Baiduspider', 'ia_archiver',
            'R6_FeedFetcher', 'NetcraftSurveyAgent', 'Sogou web spider',
            'bingbot', 'Yahoo! Slurp', 'facebookexternalhit', 'PrintfulBot',
            'msnbot', 'Twitterbot', 'UnwindFetchor',
            'urlresolver', 'Butterfly', 'TweetmemeBot' );
        
        foreach($bots as $b){
     
            if( stripos( $_SERVER['HTTP_USER_AGENT'], $b ) !== false ) return true;
     
        }
        return false;
    }

}
