<?php

namespace vendor\isenselabs\autodetect;

trait LibraryReplacementHelper {
	private $original;

	protected function initializeReplacement(&$original) {
		$this->original = $original;
		// copy references to accessible members
		foreach (get_object_vars($original) as $key => $val) {
			$this->$key = $original->$key;
		}
		// copy values of inaccessible members
		$originalClass = get_class($original);
		$classes = array_reverse(class_parents($originalClass), true) + [$originalClass => $originalClass]; // we need the entire inheritance hierarchy
		foreach ($classes as $class) {
			$refClass = new \ReflectionClass($class);
			foreach ($refClass->getProperties() as $prop) {
				if ($prop->isPrivate()) {
					$prop->setAccessible(true);
					$prop->setValue($this, $prop->getValue($original));
					$prop->setAccessible(false);
				}
			}
		}
	}

	// update private members
	public function __set($key, $value) {
		// we've already inserted references to visible parent members in the constructor, so we only get here if we try to set a private/actually non-existant member
		if (property_exists($this->original, $key)) {
			$refObj = new \ReflectionObject($this->original);
			$prop = $refObj->getProperty($key);
			$prop->setAccessible(true);
			$prop->setValue($this, $value);
			// optional - also update the property in the original object
			$prop->setValue($this->original, $value);
			$prop->setAccessible(false);
		} else {
			// neither $this, nor the parent has this key, handle custom __set logic here or call parent::__set
			// parent::__set is needed for propagation through multiple layers of replaced objects
			if (method_exists($this->original, '__set')) {
				parent::__set($key, $value);
			} else {
				// custom __set logic
			}
		}
	}

	// access private members
	public function __get($key) {
		// we've already inserted references to visible parent members in the constructor, so we only get here if we try to get a private/actually non-existant member
		if (property_exists($this->original, $key)) {
			$refObj = new \ReflectionObject($this->original);
			$prop = $refObj->getProperty($key);
			$prop->setAccessible(true);
			return $prop->getValue($this);
		} else {
			// neither $this, nor the parent has this key, handle custom __get logic here or call parent::__get
			// parent::__get is needed for propagation through multiple layers of replaced objects
			if (method_exists($this->original, '__get')) {
				return parent::__get($key, $value);
			} else {
				return null; // or throw
			}
		}
	}

}