<?php
class ModelLocalisationCountry extends Model {
	public function addCountry($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "country SET name = '" . $this->db->escape($data['name']) . "', iso_code_2 = '" . $this->db->escape($data['iso_code_2']) . "', iso_code_3 = '" . $this->db->escape($data['iso_code_3']) . "', address_format = '" . $this->db->escape($data['address_format']) . "', postcode_required = '" . (int)$data['postcode_required'] . "', status = '" . (int)$data['status'] . "'");

		$this->cache->delete('country');
		
		return $this->db->getLastId();
	}

	public function editCountry($country_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "country SET name = '" . $this->db->escape($data['name']) . "', iso_code_2 = '" . $this->db->escape($data['iso_code_2']) . "', iso_code_3 = '" . $this->db->escape($data['iso_code_3']) . "', address_format = '" . $this->db->escape($data['address_format']) . "', postcode_required = '" . (int)$data['postcode_required'] . "', status = '" . (int)$data['status'] . "' WHERE country_id = '" . (int)$country_id . "'");

		$this->cache->delete('country');
	}

	public function deleteCountry($country_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "country WHERE country_id = '" . (int)$country_id . "'");

		$this->cache->delete('country');
	}

	public function getCountry($country_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "country WHERE country_id = '" . (int)$country_id . "'");

		return $query->row;
	}

	public function getCountries($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "country";

			$sort_data = array(

			// CountryManager
				'country_id',
			// CountryManager end
			
				'name',
				'iso_code_2',
				'iso_code_3'
			);


	// CountryManager
			$sql .= " WHERE name <> 'AlexDW' ";
		if (isset($data['filter_id'])) {
			$sql .= " AND country_id LIKE '%" . (int)$data['filter_id'] . "%'";
		}

		if (isset($data['filter_status'])) {
		if (($data['filter_status']) == 1) {
			$sql .= " AND status = '1'";
		} else {
			$sql .= " AND status <> '1'";
		}
		}

		if (isset($data['filter_code'])) {
		if (($data['filter_code']) == 1) {
			$sql .= " AND postcode_required = '1'";
		} else {
			$sql .= " AND postcode_required <> '1'";
		}
		}

		if (isset($data['filter_country'])) {
			$sql .= " AND name LIKE '%" . $this->db->escape($data['filter_country']) . "%'";
		}

		if (isset($data['filter_iso2'])) {
			$sql .= " AND iso_code_2 LIKE '%" . $this->db->escape($data['filter_iso2']) . "%'";
		}

		if (isset($data['filter_iso3'])) {
			$sql .= " AND iso_code_3 LIKE '%" . $this->db->escape($data['filter_iso3']) . "%'";
		}
	// CountryManager end
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];
			} else {
				$sql .= " ORDER BY name";
			}

			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

			$query = $this->db->query($sql);

			return $query->rows;
		} else {
			$country_data = $this->cache->get('country.admin');

			if (!$country_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "country ORDER BY name ASC");

				$country_data = $query->rows;

				$this->cache->set('country.admin', $country_data);
			}

			return $country_data;
		}
	}


	// CountryManager
		public function getTotalCountryManager($data = array()) {
		
			$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "country ";
			$sql .= " WHERE 1 ";

		if (isset($data['filter_id'])) {
			$sql .= " AND country_id LIKE '%" . (int)$data['filter_id'] . "%'";
		}

		if (isset($data['filter_status'])) {
		if (($data['filter_status']) == 1) {
			$sql .= " AND status = '1'";
		} else {
			$sql .= " AND status <> '1'";
		}
		}

		if (isset($data['filter_code'])) {
		if (($data['filter_code']) == 1) {
			$sql .= " AND postcode_required = '1'";
		} else {
			$sql .= " AND postcode_required <> '1'";
		}
		}

		if (isset($data['filter_country'])) {
			$sql .= " AND name LIKE '%" . $this->db->escape($data['filter_country']) . "%'";
		}

		if (isset($data['filter_iso2'])) {
			$sql .= " AND iso_code_2 LIKE '%" . $this->db->escape($data['filter_iso2']) . "%'";
		}

		if (isset($data['filter_iso3'])) {
			$sql .= " AND iso_code_3 LIKE '%" . $this->db->escape($data['filter_iso3']) . "%'";
		}
			$query = $this->db->query($sql);

			return $query->row['total'];
		}

		public function disableAllCountry() {
			$query = $this->db->query("UPDATE " . DB_PREFIX . "country SET `status`='0' ");
			$this->cache->delete('country');
		}

		public function enableAllCountry() {
			$query = $this->db->query("UPDATE " . DB_PREFIX . "country SET `status`='1' ");
			$this->cache->delete('country');
		}

		public function enableCountry($country_id) {
			$this->db->query("UPDATE " . DB_PREFIX . "country SET `status`='1' WHERE country_id = '" . (int)$country_id . "'");
			$this->cache->delete('country');	
		}

		public function disableCountry($country_id) {
			$this->db->query("UPDATE " . DB_PREFIX . "country SET `status`='0' WHERE country_id = '" . (int)$country_id . "'");
			$this->cache->delete('country');	
		}
	// CountryManager end
			
	public function getTotalCountries() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "country");

		return $query->row['total'];
	}
}